/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.accounting.traffic;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public final class AtomicTrafficAccountant
implements TrafficAccountant {
    private final long checkPeriodMillis;
    private final long readBandwidthThreshold;
    private final long writeBandwidthThreshold;
    private final long warningClearDuration;
    private final Clock clock;
    private final Log userLog;
    private final AtomicLong lastCheckMillis = new AtomicLong();
    private final AtomicLong bytesReadSinceLastCheck = new AtomicLong();
    private final AtomicLong bytesWrittenSinceLastCheck = new AtomicLong();
    private volatile long readThresholdLastExceededAt;
    private volatile long writeThresholdLastExceededAt;

    AtomicTrafficAccountant(long checkPeriodMillis, long readBandwidthThreshold, long writeBandwidthThreshold, long warningClearDuration, Clock clock, LogService logging) {
        this.checkPeriodMillis = checkPeriodMillis;
        this.readBandwidthThreshold = readBandwidthThreshold;
        this.writeBandwidthThreshold = writeBandwidthThreshold;
        this.warningClearDuration = warningClearDuration;
        this.clock = clock;
        this.userLog = logging.getUserLog(TrafficAccountant.class);
    }

    public AtomicTrafficAccountant(long checkPeriodMillis, long readBandwidthThreshold, long writeBandwidthThreshold, long warningClearDuration, LogService logging) {
        this(checkPeriodMillis, readBandwidthThreshold, writeBandwidthThreshold, warningClearDuration, Clock.systemUTC(), logging);
    }

    @Override
    public void notifyRead(long bytes) {
        this.bytesReadSinceLastCheck.addAndGet(bytes);
    }

    @Override
    public void notifyWrite(long bytes) {
        this.bytesWrittenSinceLastCheck.addAndGet(bytes);
    }

    @Override
    public void tryCheck() {
        long now;
        long lastCheckMillis;
        do {
            lastCheckMillis = this.lastCheckMillis.get();
            now = this.clock.millis();
            if (now - lastCheckMillis >= this.checkPeriodMillis) continue;
            return;
        } while (!this.lastCheckMillis.compareAndSet(lastCheckMillis, now));
        this.check(now, lastCheckMillis);
    }

    private void check(long now, long lastCheckMillis) {
        long windowDuration = now - lastCheckMillis;
        this.checkReadBytes(now, windowDuration);
        this.checkWrittenBytes(now, windowDuration);
    }

    private void checkReadBytes(long now, long windowDuration) {
        long millisSinceLastExceeded;
        long bytesSinceLastCheck = this.bytesReadSinceLastCheck.getAndSet(0L);
        double bandwidth = (double)bytesSinceLastCheck * 8.0 / 1000000.0 * (1000.0 / (double)windowDuration);
        if (bandwidth > (double)this.readBandwidthThreshold) {
            if (this.readThresholdLastExceededAt == 0L) {
                this.userLog.warn("Inbound bandwidth threshold has been exceeded (%.2f Mb/s exceeds configured threshold of %.2f Mb/s)", new Object[]{bandwidth, Float.valueOf(this.readBandwidthThreshold)});
            }
            this.readThresholdLastExceededAt = now;
        } else if (this.readThresholdLastExceededAt != 0L && (millisSinceLastExceeded = now - this.readThresholdLastExceededAt) >= this.warningClearDuration) {
            this.userLog.info("Inbound bandwidth has normalized (traffic has dropped below %.2f Mb/s for at least %d ms)", new Object[]{Float.valueOf(this.readBandwidthThreshold), this.warningClearDuration});
            this.readThresholdLastExceededAt = 0L;
        }
    }

    private void checkWrittenBytes(long now, long windowDuration) {
        long millisSinceLastExceeded;
        long bytesSinceLastCheck = this.bytesWrittenSinceLastCheck.getAndSet(0L);
        double bandwidth = (double)bytesSinceLastCheck * 8.0 / 1000000.0 * (1000.0 / (double)windowDuration);
        if (bandwidth > (double)this.writeBandwidthThreshold) {
            if (this.writeThresholdLastExceededAt == 0L) {
                this.userLog.warn("Outbound bandwidth threshold has been exceeded (%.2f Mb/s exceeds configured threshold of %.2f Mb/s)", new Object[]{bandwidth, Float.valueOf(this.writeBandwidthThreshold)});
            }
            this.writeThresholdLastExceededAt = now;
        } else if (this.writeThresholdLastExceededAt != 0L && (millisSinceLastExceeded = now - this.writeThresholdLastExceededAt) >= this.warningClearDuration) {
            this.userLog.info("Outbound bandwidth has normalized (traffic has dropped below %.2f Mb/s for at least %d ms)", new Object[]{Float.valueOf(this.writeBandwidthThreshold), this.warningClearDuration});
            this.writeThresholdLastExceededAt = 0L;
        }
    }
}

