/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.Map;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.fsm.StateMachineFactoryImpl;
import org.neo4j.bolt.fsm.StateMachineImpl;
import org.neo4j.bolt.fsm.error.NoSuchStateException;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.connector.connection.ConnectionHandle;
import org.neo4j.dbms.admissioncontrol.AdmissionControlService;
import org.neo4j.logging.internal.LogService;

final class ImmutableStateMachineConfiguration
implements StateMachineConfiguration {
    private final State initialState;
    private final Map<StateReference, State> stateMap;

    public ImmutableStateMachineConfiguration(State initialState, Map<StateReference, State> stateMap) {
        this.initialState = initialState;
        this.stateMap = stateMap;
    }

    @Override
    public StateMachineConfiguration.Factory builderOf() {
        StateMachineFactoryImpl factory = new StateMachineFactoryImpl().withInitialState(this.initialState.reference(), this.initialState.builderOf());
        this.stateMap.values().stream().filter(state -> this.initialState != state).forEach(state -> factory.withState(state.reference(), state.builderOf()));
        return factory;
    }

    @Override
    public StateReference initialState() {
        return this.initialState.reference();
    }

    @Override
    public State lookup(StateReference reference) throws NoSuchStateException {
        State state = this.stateMap.get(reference);
        if (state == null) {
            throw new NoSuchStateException(reference);
        }
        return state;
    }

    @Override
    public StateMachine createInstance(ConnectionHandle connection, LogService logService, AdmissionControlService admissionControlService) {
        return new StateMachineImpl(connection, this, logService, this.initialState, admissionControlService);
    }
}

