/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.error;

import org.neo4j.bolt.fsm.error.ConnectionTerminating;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.kernel.api.exceptions.Status;

public class NoSuchStateException
extends StateMachineException
implements Status.HasStatus,
ConnectionTerminating,
ErrorGqlStatusObject {
    private final StateReference target;
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public NoSuchStateException(StateReference target, Throwable cause) {
        super("No such state: " + target.name(), cause);
        this.target = target;
        this.gqlStatusObject = null;
        this.oldMessage = "No such state: " + target.name();
    }

    public NoSuchStateException(ErrorGqlStatusObject gqlStatusObject, StateReference target, Throwable cause) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)("No such state: " + target.name())), cause);
        this.gqlStatusObject = gqlStatusObject;
        this.oldMessage = "No such state: " + target.name();
        this.target = target;
    }

    public NoSuchStateException(StateReference target) {
        this(target, null);
    }

    public NoSuchStateException(ErrorGqlStatusObject gqlStatusObject, StateReference target) {
        this(gqlStatusObject, target, null);
    }

    public StateReference getTarget() {
        return this.target;
    }

    public Status status() {
        return Status.General.UnknownError;
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

