/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.writer;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.neo4j.bolt.protocol.io.pipeline.WriterContext;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public interface StructWriter {
    default public void writePoint(WriterContext ctx, CoordinateReferenceSystem crs, double[] coords) {
        ctx.firePoint(crs, coords);
    }

    default public void writeDuration(WriterContext ctx, long months, long days, long seconds, int nanos) {
        ctx.fireDuration(months, days, seconds, nanos);
    }

    default public void writeDate(WriterContext ctx, LocalDate localDate) {
        ctx.fireDate(localDate);
    }

    default public void writeLocalTime(WriterContext ctx, LocalTime localTime) {
        ctx.fireLocalTime(localTime);
    }

    default public void writeTime(WriterContext ctx, OffsetTime offsetTime) {
        ctx.fireTime(offsetTime);
    }

    default public void writeLocalDateTime(WriterContext ctx, LocalDateTime localDateTime) {
        ctx.fireLocalDateTime(localDateTime);
    }

    default public void writeDateTime(WriterContext ctx, OffsetDateTime offsetDateTime) {
        ctx.fireDateTime(offsetDateTime);
    }

    default public void writeDateTime(WriterContext ctx, ZonedDateTime zonedDateTime) {
        ctx.fireDateTime(zonedDateTime);
    }

    default public void writeNode(WriterContext ctx, String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        ctx.fireNode(elementId, nodeId, labels, properties, isDeleted);
    }

    default public void writeRelationship(WriterContext ctx, String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) {
        ctx.fireRelationship(elementId, relId, startNodeElementId, startNodeId, endNodeElementId, endNodeId, type, properties, isDeleted);
    }

    default public void writeUnboundRelationship(WriterContext ctx, String elementId, long relId, String type, MapValue properties) {
        ctx.fireUnboundRelationship(elementId, relId, type, properties);
    }

    default public void writePath(WriterContext ctx, NodeValue[] nodes, RelationshipValue[] relationships) {
        ctx.firePath(nodes, relationships);
    }
}

