/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx.error;

import org.neo4j.bolt.tx.error.TransactionCreationException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.kernel.api.exceptions.Status;

public class NoSuchDatabaseTransactionCreationException
extends TransactionCreationException
implements Status.HasStatus,
ErrorGqlStatusObject {
    private final ErrorGqlStatusObject gqlStatusObject;
    private final String oldMessage;

    public NoSuchDatabaseTransactionCreationException(String databaseName, Throwable cause) {
        super(String.format("Database does not exist. Database name: '%s'.", databaseName), cause);
        this.gqlStatusObject = null;
        this.oldMessage = String.format("Database does not exist. Database name: '%s'.", databaseName);
    }

    public NoSuchDatabaseTransactionCreationException(ErrorGqlStatusObject gqlStatusObject, String databaseName, Throwable cause) {
        super(ErrorMessageHolder.getMessage((ErrorGqlStatusObject)gqlStatusObject, (String)String.format("Database does not exist. Database name: '%s'.", databaseName)), cause);
        this.gqlStatusObject = gqlStatusObject;
        this.oldMessage = String.format("Database does not exist. Database name: '%s'.", databaseName);
    }

    public String legacyMessage() {
        return this.oldMessage;
    }

    public Status status() {
        return Status.Database.DatabaseNotFound;
    }

    public ErrorGqlStatusObject gqlStatusObject() {
        return this.gqlStatusObject;
    }
}

