/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx.statement;

import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

public class StatementQuerySubscriber
implements QuerySubscriber {
    private RecordHandler handler;
    private Throwable pendingException;
    private QueryStatistics statistics;

    public void setHandler(RecordHandler handler) {
        this.handler = handler;
    }

    public Throwable getPendingException() {
        return this.pendingException;
    }

    public QueryStatistics getStatistics() {
        return this.statistics;
    }

    public void onResult(int numberOfFields) throws Exception {
    }

    public void onRecord() throws Exception {
        this.handler.onBegin();
    }

    public void onField(int offset, AnyValue value) throws Exception {
        this.handler.onField(value);
    }

    public void onRecordCompleted() throws Exception {
        this.handler.onCompleted();
    }

    public void onError(Throwable throwable) throws Exception {
        if (this.pendingException == null) {
            this.pendingException = throwable;
        }
        if (this.handler != null) {
            this.handler.onFailure();
        }
    }

    public void onResultCompleted(QueryStatistics statistics) {
        this.statistics = statistics;
    }

    public void assertSuccess() throws KernelException {
        if (this.pendingException != null) {
            Throwable throwable = this.pendingException;
            if (throwable instanceof KernelException) {
                KernelException kernelException = (KernelException)throwable;
                throw kernelException;
            }
            throwable = this.pendingException;
            if (throwable instanceof Status.HasStatus) {
                Status.HasStatus hasStatus = (Status.HasStatus)throwable;
                throw new QueryExecutionKernelException((Throwable)hasStatus);
            }
            throw new QueryExecutionKernelException((Throwable)CypherExecutionException.internalError((String)"CypherExecution", (String)this.pendingException.getMessage(), (Throwable)this.pendingException));
        }
    }
}

