/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.fsm.error.AuthenticationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.ImpersonationRequestMessage;
import org.neo4j.bolt.security.error.AuthenticationException;

public abstract class SimpleImpersonationStateTransition<R extends ImpersonationRequestMessage>
extends AbstractStateTransition<R> {
    public SimpleImpersonationStateTransition(Class<R> requestType) {
        super(requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StateReference process(Context ctx, R message, ResponseHandler handler) throws StateMachineException {
        if (message.impersonatedUser() != null) {
            try {
                ctx.connection().impersonate(message.impersonatedUser());
            }
            catch (AuthenticationException ex) {
                throw new AuthenticationStateTransitionException(ex);
            }
        }
        try {
            StateReference stateReference = this.doProcess(ctx, message, handler);
            return stateReference;
        }
        finally {
            ctx.connection().clearImpersonation();
        }
    }

    protected abstract StateReference doProcess(Context var1, R var2, ResponseHandler var3) throws StateMachineException;
}

