/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.BoltDriverMetricsMonitor;
import org.neo4j.bolt.protocol.common.connection.hint.ConnectionHintRegistry;
import org.neo4j.bolt.protocol.common.connection.hint.KeepAliveConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connection.hint.SeverSideRoutingHintProvider;
import org.neo4j.bolt.protocol.common.connection.hint.TelemetryConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.accounting.error.CircuitBreakerErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.error.NoopErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.AtomicTrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.NoopTrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.accounting.traffic.TrafficAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.AtomicSchedulingConnection;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.executor.ExecutorServiceFactory;
import org.neo4j.bolt.protocol.common.connector.executor.NettyThreadFactory;
import org.neo4j.bolt.protocol.common.connector.executor.ThreadPoolExecutorServiceFactory;
import org.neo4j.bolt.protocol.common.connector.listener.AuthenticationTimeoutConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.KeepAliveConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.MetricsConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ReadLimitConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ResetMessageConnectorListener;
import org.neo4j.bolt.protocol.common.connector.listener.ResponseMetricsConnectorListener;
import org.neo4j.bolt.protocol.common.connector.netty.AdditionalSocketNettyConnector;
import org.neo4j.bolt.protocol.common.connector.netty.DomainSocketNettyConnector;
import org.neo4j.bolt.protocol.common.connector.netty.LocalNettyConnector;
import org.neo4j.bolt.protocol.common.connector.netty.SocketNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.security.basic.BasicAuthentication;
import org.neo4j.bolt.transport.BoltMemoryPool;
import org.neo4j.bolt.transport.NettyMemoryPool;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SslSystemSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.connectors.CommonConnectorConfig;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.admissioncontrol.AdmissionControlService;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

public class BoltServer
extends LifecycleAdapter {
    @VisibleForTesting
    public static final Suppliers.Lazy<PooledByteBufAllocator> NETTY_BUF_ALLOCATOR = Suppliers.lazySingleton(() -> new PooledByteBufAllocator(PlatformDependent.directBufferPreferred()));
    private final DbmsInfo dbmsInfo;
    private final JobScheduler jobScheduler;
    private final ConnectorPortRegister connectorPortRegister;
    private final NetworkConnectionTracker connectionTracker;
    private final Config config;
    private final SystemNanoClock clock;
    private final Monitors monitors;
    private final LogService logService;
    private final AuthManager externalAuthManager;
    private final AuthManager internalAuthManager;
    private final AuthManager loopbackAuthManager;
    private final MemoryPools memoryPools;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final ConnectionHintRegistry connectionHintRegistry;
    private final ExecutorServiceFactory executorServiceFactory;
    private final SslPolicyLoader sslPolicyLoader;
    private final BoltProtocolRegistry protocolRegistry;
    private final AuthConfigProvider authConfigProvider;
    private final TransactionManager transactionManager;
    private final RoutingService routingService;
    private final InternalLog log;
    private final List<Connector> connectors = new ArrayList<Connector>();
    private final LifeSupport connectorLife = new LifeSupport();
    private final AdmissionControlService admissionControl;
    private BoltMemoryPool memoryPool;
    private EventLoopGroup bossEventLoopGroup;
    private EventLoopGroup workerEventLoopGroup;
    private ExecutorService executorService;
    private BoltConnectionMetricsMonitor connectionMetricsMonitor;
    private BoltDriverMetricsMonitor driverMetricsMonitor;

    public BoltServer(DbmsInfo dbmsInfo, JobScheduler jobScheduler, ConnectorPortRegister connectorPortRegister, NetworkConnectionTracker connectionTracker, TransactionManager transactionManager, Config config, SystemNanoClock clock, Monitors monitors, LogService logService, DependencyResolver dependencyResolver, AuthManager externalAuthManager, AuthManager internalAuthManager, AuthManager loopbackAuthManager, MemoryPools memoryPools, RoutingService routingService, DefaultDatabaseResolver defaultDatabaseResolver, AdmissionControlService admissionControl) {
        this.dbmsInfo = dbmsInfo;
        this.jobScheduler = jobScheduler;
        this.connectorPortRegister = connectorPortRegister;
        this.connectionTracker = connectionTracker;
        this.transactionManager = transactionManager;
        this.config = config;
        this.clock = clock;
        this.monitors = monitors;
        this.logService = logService;
        this.externalAuthManager = externalAuthManager;
        this.internalAuthManager = internalAuthManager;
        this.loopbackAuthManager = loopbackAuthManager;
        this.memoryPools = memoryPools;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.admissionControl = admissionControl;
        this.connectionHintRegistry = ConnectionHintRegistry.newBuilder().withProvider(new KeepAliveConnectionHintProvider(config)).withProvider(new TelemetryConnectionHintProvider(config)).withProvider(new SeverSideRoutingHintProvider(config)).build();
        this.executorServiceFactory = new ThreadPoolExecutorServiceFactory((Integer)config.get(BoltConnector.thread_pool_min_size), (Integer)config.get(BoltConnector.thread_pool_max_size), true, (Duration)config.get(BoltConnector.thread_pool_keep_alive), (Integer)config.get(BoltConnectorInternalSettings.unsupported_thread_pool_queue_size), this.jobScheduler.threadFactory(Group.BOLT_WORKER));
        this.routingService = routingService;
        this.sslPolicyLoader = (SslPolicyLoader)dependencyResolver.resolveDependency(SslPolicyLoader.class);
        this.authConfigProvider = (AuthConfigProvider)dependencyResolver.resolveDependency(AuthConfigProvider.class);
        this.log = logService.getInternalLog(BoltServer.class);
        Optional<ProtocolVersion> minProtocolVersion = Optional.ofNullable((BoltConnectorInternalSettings.ConfiguredProtocolVersion)config.get(BoltConnectorInternalSettings.min_protocol_version)).map(version -> new ProtocolVersion(version.major(), version.minor()));
        Optional<ProtocolVersion> maxProtocolVersion = Optional.ofNullable((BoltConnectorInternalSettings.ConfiguredProtocolVersion)config.get(BoltConnectorInternalSettings.max_protocol_version)).map(version -> new ProtocolVersion(version.major(), version.minor()));
        this.protocolRegistry = BoltProtocolRegistry.builder().register(minProtocolVersion.isEmpty() && maxProtocolVersion.isEmpty() ? BoltProtocol.available() : BoltProtocol.available().stream().filter(candidate -> minProtocolVersion.isEmpty() || candidate.version().isAtLeast((ProtocolVersion)minProtocolVersion.get())).filter(candidate -> maxProtocolVersion.isEmpty() || candidate.version().isAtMost((ProtocolVersion)maxProtocolVersion.get())).toList()).build();
    }

    private boolean isEnabled() {
        return (Boolean)this.config.get(BoltConnector.enabled);
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @VisibleForTesting
    public List<Connector> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void init() {
        if (!this.isEnabled()) {
            return;
        }
        if (((Boolean)this.config.get(CommonConnectorConfig.ocsp_stapling_enabled)).booleanValue()) {
            this.enableOcspStapling();
            this.log.info("Enabled OCSP stapling support");
        }
        this.jobScheduler.setThreadFactory(Group.BOLT_NETWORK_IO, NettyThreadFactory::new);
        Predicate<ConnectorTransport> filter = (Boolean)this.config.get(BoltConnectorInternalSettings.use_native_transport) != false ? transport -> true : Predicate.not(ConnectorTransport::isNative);
        ConnectorTransport transport2 = ConnectorTransport.selectOptimal(filter).orElseThrow(() -> new IllegalStateException("No transport implementations available within current environment"));
        this.log.info("Using connector transport %s", new Object[]{transport2.getName()});
        this.bossEventLoopGroup = transport2.createEventLoopGroup(this.jobScheduler.threadFactory(Group.BOLT_NETWORK_IO));
        this.workerEventLoopGroup = transport2.createEventLoopGroup(this.jobScheduler.threadFactory(Group.BOLT_NETWORK_IO));
        this.executorService = this.executorServiceFactory.create();
        this.connectionMetricsMonitor = (BoltConnectionMetricsMonitor)this.monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0]);
        this.driverMetricsMonitor = (Boolean)this.config.get(BoltConnector.server_bolt_telemetry_enabled) != false ? (BoltDriverMetricsMonitor)this.monitors.newMonitor(BoltDriverMetricsMonitor.class, new String[0]) : BoltDriverMetricsMonitor.noop();
        ByteBufAllocator allocator = this.getBufferAllocator();
        Connection.Factory connectionFactory = this.createConnectionFactory();
        Integer streamingBufferSize = (Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size);
        Integer streamingFlushThreshold = (Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold);
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_loopback_auth)).booleanValue()) {
            this.registerConnector(this.createDomainSocketConnector(connectionFactory, transport2, BoltServer.createAuthentication(this.loopbackAuthManager), allocator));
            this.log.info("Configured loopback (domain socket) Bolt connector");
        }
        InetSocketAddress listenAddress = ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.listen_address)).socketAddress();
        BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)this.config.get(BoltConnector.encryption_level);
        boolean encryptionRequired = encryptionLevel == BoltConnector.EncryptionLevel.REQUIRED;
        SslContext sslContext = null;
        if (encryptionLevel != BoltConnector.EncryptionLevel.DISABLED) {
            if (!this.sslPolicyLoader.hasPolicyForSource(SslPolicyScope.BOLT)) {
                throw new IllegalStateException("Requested encryption level " + String.valueOf(encryptionLevel) + " for Bolt connector but no SSL policy was given");
            }
            try {
                sslContext = this.sslPolicyLoader.getPolicy(SslPolicyScope.BOLT).nettyServerContext();
            }
            catch (SSLException ex) {
                throw new IllegalStateException("Failed to load SSL policy for Bolt connector", ex);
            }
        }
        this.registerConnector(this.createSocketConnector(listenAddress, connectionFactory, encryptionRequired, transport2, sslContext, BoltServer.createAuthentication(this.externalAuthManager), ConnectorType.BOLT, allocator));
        for (org.neo4j.configuration.helpers.SocketAddress address : (Set)this.config.get(BoltConnector.additional_listen_addresses)) {
            this.registerConnector(this.createAdditionalSocketConnector(address.socketAddress(), connectionFactory, encryptionRequired, transport2, sslContext, BoltServer.createAuthentication(this.externalAuthManager), ConnectorType.BOLT, allocator));
        }
        this.log.info("Configured external Bolt connector with listener address %s", new Object[]{listenAddress});
        boolean isRoutingEnabled = (Boolean)this.config.get(GraphDatabaseSettings.routing_enabled);
        if (isRoutingEnabled && this.dbmsInfo == DbmsInfo.ENTERPRISE) {
            InetSocketAddress internalListenAddress = this.config.isExplicitlySet(GraphDatabaseSettings.routing_listen_address) ? ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(GraphDatabaseSettings.routing_listen_address)).socketAddress() : new InetSocketAddress(((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.listen_address)).getHostname(), ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(GraphDatabaseSettings.routing_listen_address)).getPort());
            boolean internalEncryptionRequired = false;
            SslContext internalSslContext = null;
            if (this.sslPolicyLoader.hasPolicyForSource(SslPolicyScope.CLUSTER)) {
                internalEncryptionRequired = true;
                try {
                    internalSslContext = this.sslPolicyLoader.getPolicy(SslPolicyScope.CLUSTER).nettyServerContext();
                }
                catch (SSLException ex) {
                    throw new IllegalStateException("Failed to load SSL policy for server side routing within Bolt: Cluster policy", ex);
                }
            }
            this.registerConnector(this.createSocketConnector(internalListenAddress, connectionFactory, internalEncryptionRequired, transport2, internalSslContext, BoltServer.createAuthentication(this.internalAuthManager), ConnectorType.INTRA_BOLT, allocator));
            this.log.info("Configured internal Bolt connector with listener address %s", new Object[]{internalListenAddress});
        }
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_local_connector)).booleanValue()) {
            this.registerConnector(this.createLocalConnector(connectionFactory, transport2, BoltServer.createAuthentication(this.externalAuthManager), allocator, streamingBufferSize, streamingFlushThreshold));
        }
        this.log.info("Bolt server loaded");
        this.connectorLife.init();
    }

    public void start() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.connectorLife.start();
        this.log.info("Bolt server started");
    }

    public void stop() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.log.info("Requested Bolt server shutdown");
        this.connectorLife.stop();
    }

    public void shutdown() {
        if (this.isEnabled()) {
            this.log.info("Shutting down Bolt server");
            Future bossTerminationFuture = this.bossEventLoopGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS);
            boolean bossTerminationCompleted = bossTerminationFuture.awaitUninterruptibly(((Duration)this.config.get(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time)).toSeconds(), TimeUnit.SECONDS);
            if (!bossTerminationCompleted) {
                this.log.warn("Termination of boss event loop group has exceeded maximum permitted duration - Remaining jobs will be forcefully terminated");
            } else if (!bossTerminationFuture.isSuccess()) {
                this.log.warn("Termination of boss event loop group has failed", bossTerminationFuture.cause());
            }
            this.connectorLife.shutdown();
            Future workerTerminationFuture = this.workerEventLoopGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS);
            boolean workerTerminationCompleted = workerTerminationFuture.awaitUninterruptibly(((Duration)this.config.get(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time)).toSeconds(), TimeUnit.SECONDS);
            if (!workerTerminationCompleted) {
                this.log.warn("Termination of worker event loop group has exceeded maximum permitted duration - Remaining jobs will be forcefully terminated");
            } else if (!workerTerminationFuture.isSuccess()) {
                this.log.warn("Termination of worker event loop group has failed", workerTerminationFuture.cause());
            }
            List<Runnable> remainingJobs = this.executorService.shutdownNow();
            if (!remainingJobs.isEmpty()) {
                this.log.warn("Forcefully killed %d remaining Bolt jobs to fulfill shutdown request", new Object[]{remainingJobs.size()});
            }
            this.log.info("Bolt server has been shut down");
        }
        if (this.memoryPool != null) {
            this.memoryPool.close();
        }
    }

    private ByteBufAllocator getBufferAllocator() {
        PooledByteBufAllocator allocator = (PooledByteBufAllocator)NETTY_BUF_ALLOCATOR.get();
        BoltMemoryPool pool = new BoltMemoryPool(this.memoryPools, (ByteBufAllocatorMetric)allocator.metric());
        this.connectorLife.add((Lifecycle)new BoltMemoryPoolLifeCycleAdapter(pool));
        this.memoryPool = pool;
        return allocator;
    }

    private void registerConnector(Connector connector) {
        Long readLimit;
        Duration authenticationTimeout;
        connector.registerListener(new MetricsConnectorListener(this.connectionMetricsMonitor));
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.enable_response_metrics)).booleanValue()) {
            connector.registerListener(new ResponseMetricsConnectorListener(this.connectionMetricsMonitor));
        }
        if (!(authenticationTimeout = (Duration)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout)).isZero()) {
            connector.registerListener(new AuthenticationTimeoutConnectorListener(authenticationTimeout, this.logService.getInternalLogProvider()));
        }
        BoltConnector.KeepAliveRequestType keepAliveMechanism = (BoltConnector.KeepAliveRequestType)this.config.get(BoltConnector.connection_keep_alive_type);
        long keepAliveInterval = ((Duration)this.config.get(BoltConnector.connection_keep_alive)).toMillis();
        if (keepAliveMechanism != BoltConnector.KeepAliveRequestType.OFF) {
            connector.registerListener(new KeepAliveConnectorListener(keepAliveMechanism != BoltConnector.KeepAliveRequestType.ALL, keepAliveInterval, this.logService.getInternalLogProvider()));
        }
        if ((readLimit = (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes)) != 0L) {
            connector.registerListener(new ReadLimitConnectorListener(readLimit, this.logService.getInternalLogProvider()));
        }
        connector.registerListener(new ResetMessageConnectorListener(this.logService.getInternalLogProvider()));
        this.connectors.add(connector);
        this.connectorLife.add((Lifecycle)connector);
    }

    private Connection.Factory createConnectionFactory() {
        return new AtomicSchedulingConnection.Factory(this.executorService, (Clock)this.clock, this.logService, this.admissionControl);
    }

    private static Authentication createAuthentication(AuthManager authManager) {
        return new BasicAuthentication(authManager);
    }

    private void enableOcspStapling() {
        if (!SslProvider.JDK.equals(this.config.get(SslSystemSettings.netty_ssl_provider))) {
            throw new IllegalArgumentException("OCSP Server stapling can only be used with JDK ssl provider (see " + SslSystemSettings.netty_ssl_provider.name() + ")");
        }
        System.setProperty("jdk.tls.server.enableStatusRequestExtension", "true");
    }

    private Connector createSocketConnector(SocketAddress bindAddress, Connection.Factory connectionFactory, boolean encryptionRequired, ConnectorTransport transport, SslContext sslContext, Authentication authentication, ConnectorType connectorType, ByteBufAllocator allocator) {
        SocketNettyConnector.SocketConfiguration config = new SocketNettyConnector.SocketConfiguration((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_capture), (Path)this.config.get(BoltConnectorInternalSettings.protocol_capture_path), (Boolean)this.config.get(BoltConnectorInternalSettings.protocol_logging), (BoltConnectorInternalSettings.ProtocolLoggingMode)this.config.get(BoltConnectorInternalSettings.protocol_logging_mode), (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_elements), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_depth), (Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark), (Duration)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold), (Duration)this.config.get(BoltConnectorInternalSettings.connection_shutdown_wait_time), (Boolean)this.config.get(BoltConnectorInternalSettings.transaction_thread_binding), (Duration)this.config.get(BoltConnectorInternalSettings.thread_binding_timeout), ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.advertised_address)).socketAddress(), (Boolean)this.config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator), encryptionRequired, sslContext, (Boolean)this.config.get(BoltConnectorInternalSettings.tcp_keep_alive));
        return new SocketNettyConnector("bolt", bindAddress, connectorType, this.connectorPortRegister, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.bossEventLoopGroup, this.workerEventLoopGroup, transport, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintRegistry, this.transactionManager, this.routingService, this.createErrorAccountant(), this.createTrafficAccountant(), this.driverMetricsMonitor, config, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider());
    }

    private Connector createAdditionalSocketConnector(SocketAddress bindAddress, Connection.Factory connectionFactory, boolean encryptionRequired, ConnectorTransport transport, SslContext sslContext, Authentication authentication, ConnectorType connectorType, ByteBufAllocator allocator) {
        SocketNettyConnector.SocketConfiguration config = new SocketNettyConnector.SocketConfiguration((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_capture), (Path)this.config.get(BoltConnectorInternalSettings.protocol_capture_path), (Boolean)this.config.get(BoltConnectorInternalSettings.protocol_logging), (BoltConnectorInternalSettings.ProtocolLoggingMode)this.config.get(BoltConnectorInternalSettings.protocol_logging_mode), (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_elements), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_depth), (Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark), (Duration)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold), (Duration)this.config.get(BoltConnectorInternalSettings.connection_shutdown_wait_time), (Boolean)this.config.get(BoltConnectorInternalSettings.transaction_thread_binding), (Duration)this.config.get(BoltConnectorInternalSettings.thread_binding_timeout), ((org.neo4j.configuration.helpers.SocketAddress)this.config.get(BoltConnector.advertised_address)).socketAddress(), (Boolean)this.config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator), encryptionRequired, sslContext, (Boolean)this.config.get(BoltConnectorInternalSettings.tcp_keep_alive));
        return new AdditionalSocketNettyConnector("bolt", bindAddress, connectorType, this.connectorPortRegister, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.bossEventLoopGroup, this.workerEventLoopGroup, transport, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintRegistry, this.transactionManager, this.routingService, this.createErrorAccountant(), this.createTrafficAccountant(), this.driverMetricsMonitor, config, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider());
    }

    private Connector createDomainSocketConnector(Connection.Factory connectionFactory, ConnectorTransport transport, Authentication authentication, ByteBufAllocator allocator) {
        DomainSocketNettyConnector.DomainSocketConfiguration config = new DomainSocketNettyConnector.DomainSocketConfiguration((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_capture), (Path)this.config.get(BoltConnectorInternalSettings.protocol_capture_path), (Boolean)this.config.get(BoltConnectorInternalSettings.protocol_logging), (BoltConnectorInternalSettings.ProtocolLoggingMode)this.config.get(BoltConnectorInternalSettings.protocol_logging_mode), (Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_elements), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_depth), (Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark), (Duration)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size), (Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold), (Duration)this.config.get(BoltConnectorInternalSettings.connection_shutdown_wait_time), (Boolean)this.config.get(BoltConnectorInternalSettings.transaction_thread_binding), (Duration)this.config.get(BoltConnectorInternalSettings.thread_binding_timeout), (Boolean)this.config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator), (Boolean)this.config.get(BoltConnectorInternalSettings.unsupported_loopback_delete));
        Path socketFile = (Path)this.config.get(BoltConnectorInternalSettings.unsupported_loopback_listen_file);
        if (socketFile == null) {
            throw new IllegalArgumentException("A file has not been specified for use with the loopback domain socket.");
        }
        return new DomainSocketNettyConnector("bolt-loopback", socketFile, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.bossEventLoopGroup, this.bossEventLoopGroup, transport, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintRegistry, this.transactionManager, this.routingService, this.createErrorAccountant(), this.driverMetricsMonitor, config, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider());
    }

    private Connector createLocalConnector(Connection.Factory connectionFactory, ConnectorTransport transport, Authentication authentication, ByteBufAllocator allocator, int streamingBufferSize, int streamingFlushThreshold) {
        LocalNettyConnector.LocalConfiguration config = new LocalNettyConnector.LocalConfiguration((boolean)((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_capture)), (Path)this.config.get(BoltConnectorInternalSettings.protocol_capture_path), (boolean)((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_logging)), (BoltConnectorInternalSettings.ProtocolLoggingMode)this.config.get(BoltConnectorInternalSettings.protocol_logging_mode), (long)((Long)this.config.get(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_elements)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_unauth_connection_max_structure_depth)), (boolean)((Boolean)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_low_water_mark)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_high_water_mark)), (Duration)this.config.get(BoltConnectorInternalSettings.bolt_outbound_buffer_throttle_max_duration), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_low_water_mark)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.bolt_inbound_message_throttle_high_water_mark)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.streaming_buffer_size)), (int)((Integer)this.config.get(BoltConnectorInternalSettings.streaming_flush_threshold)), (Duration)this.config.get(BoltConnectorInternalSettings.connection_shutdown_wait_time), (boolean)((Boolean)this.config.get(BoltConnectorInternalSettings.transaction_thread_binding)), (Duration)this.config.get(BoltConnectorInternalSettings.thread_binding_timeout), (Boolean)this.config.get(BoltConnectorInternalSettings.netty_message_merge_cumulator));
        LocalAddress bindAddress = new LocalAddress((String)this.config.get(BoltConnectorInternalSettings.local_channel_address));
        return new LocalNettyConnector("bolt-local", (SocketAddress)bindAddress, (MemoryPool)this.memoryPool, (Clock)this.clock, allocator, this.bossEventLoopGroup, this.workerEventLoopGroup, connectionFactory, this.connectionTracker, this.protocolRegistry, authentication, this.authConfigProvider, this.defaultDatabaseResolver, this.connectionHintRegistry, this.transactionManager, this.routingService, this.createErrorAccountant(), this.driverMetricsMonitor, this.logService.getUserLogProvider(), this.logService.getInternalLogProvider(), transport, config);
    }

    private ErrorAccountant createErrorAccountant() {
        if (!((Boolean)this.config.get(BoltConnector.enable_error_accounting)).booleanValue()) {
            return new NoopErrorAccountant(this.logService);
        }
        return new CircuitBreakerErrorAccountant((Long)this.config.get(BoltConnector.network_abort_warn_threshold), ((Duration)this.config.get(BoltConnector.network_abort_warn_window_duration)).toMillis(), ((Duration)this.config.get(BoltConnector.network_abort_clear_window_duration)).toMillis(), (Long)this.config.get(BoltConnector.thread_starvation_warn_threshold), ((Duration)this.config.get(BoltConnector.thread_starvation_warn_window_duration)).toMillis(), ((Duration)this.config.get(BoltConnector.thread_starvation_clear_window_duration)).toMillis(), Clock.systemUTC(), this.logService);
    }

    private TrafficAccountant createTrafficAccountant() {
        Duration checkPeriod = (Duration)this.config.get(BoltConnector.traffic_accounting_check_period);
        if (Duration.ZERO.equals(checkPeriod)) {
            return NoopTrafficAccountant.getInstance();
        }
        return new AtomicTrafficAccountant(((Duration)this.config.get(BoltConnector.traffic_accounting_check_period)).toMillis(), (Long)this.config.get(BoltConnector.traffic_accounting_incoming_threshold_mbps), (Long)this.config.get(BoltConnector.traffic_accounting_outgoing_threshold_mbps), ((Duration)this.config.get(BoltConnector.traffic_accounting_clear_duration)).toMillis(), this.logService);
    }

    private static class BoltMemoryPoolLifeCycleAdapter
    extends LifecycleAdapter {
        private final NettyMemoryPool pool;

        private BoltMemoryPoolLifeCycleAdapter(NettyMemoryPool pool) {
            this.pool = pool;
        }

        public void shutdown() {
            this.pool.close();
        }
    }
}

