/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import org.neo4j.bolt.negotiation.ProtocolVersion;

public final class ProtocolVersionReducer {
    private short currentMajor = (short)-1;
    private short initialMinor = (short)-1;
    private short currentMinor = (short)-1;
    private final List<ProtocolVersion> versions = new ArrayList<ProtocolVersion>();

    public static List<ProtocolVersion> canonicalize(Iterable<ProtocolVersion> versions) {
        ProtocolVersionReducer reducer = new ProtocolVersionReducer();
        StreamSupport.stream(versions.spliterator(), false).flatMap(version -> version.unwind().stream()).sorted(ProtocolVersion::compareTo).forEachOrdered(reducer::submit);
        return reducer.finalizeResult();
    }

    public void submit(ProtocolVersion version) {
        if (version.major() != this.currentMajor) {
            this.rollMajor(version);
        } else if (this.currentMinor + 1 != version.minor()) {
            this.rollMajor(version);
        } else {
            this.currentMinor = version.minor();
        }
    }

    private void rollMajor(ProtocolVersion version) {
        short previousMajor = this.currentMajor;
        short initialMinor = this.initialMinor;
        short previousMinor = this.currentMinor;
        this.currentMajor = version.major();
        this.initialMinor = this.currentMinor = version.minor();
        if (previousMajor == -1) {
            return;
        }
        this.onFinalizeMajor(previousMajor, initialMinor, previousMinor);
    }

    private void onFinalizeMajor(short major, short initialMinor, short latestMinor) {
        int range = latestMinor - initialMinor;
        this.versions.add(new ProtocolVersion((int)major, (int)latestMinor, range));
    }

    public List<ProtocolVersion> finalizeResult() {
        this.rollMajor(ProtocolVersion.INVALID);
        return new ArrayList<ProtocolVersion>(this.versions);
    }

    public void reset() {
        this.currentMajor = (short)-1;
        this.initialMinor = (short)-1;
        this.currentMinor = (short)-1;
    }
}

