/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.transaction;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.TransactionalStateTransition;
import org.neo4j.bolt.protocol.common.message.request.transaction.RunMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.statement.Statement;

public final class CreateStatementStateTransition
extends TransactionalStateTransition<RunMessage> {
    private static final CreateStatementStateTransition INSTANCE = new CreateStatementStateTransition();

    private CreateStatementStateTransition() {
        super(RunMessage.class);
    }

    public static CreateStatementStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    protected StateReference process(Context ctx, Transaction tx, RunMessage message, ResponseHandler handler) throws StateMachineException {
        long start = ctx.clock().millis();
        try {
            Statement statement = tx.run(message.statement(), message.params());
            long end = ctx.clock().millis();
            handler.onStatementPrepared(TransactionType.EXPLICIT, statement.id(), end - start, statement.fieldNames());
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        return ctx.state();
    }
}

