/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.DateValue;

public final class DateReader<CTX>
implements StructReader<CTX, DateValue> {
    private static final DateReader<?> INSTANCE = new DateReader();

    private DateReader() {
    }

    public static <CTX> DateReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.DATE.getTag();
    }

    @Override
    public DateValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        long epochDays = buffer.readInt();
        return DateValue.epochDate((long)epochDays);
    }
}

