/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v50;

import java.time.Clock;
import java.util.Set;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeReader;
import org.neo4j.bolt.protocol.io.reader.DateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.reader.DurationReader;
import org.neo4j.bolt.protocol.io.reader.LocalDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.LocalTimeReader;
import org.neo4j.bolt.protocol.io.reader.Point2dReader;
import org.neo4j.bolt.protocol.io.reader.Point3dReader;
import org.neo4j.bolt.protocol.io.reader.TimeReader;
import org.neo4j.bolt.protocol.io.writer.DefaultStructWriter;
import org.neo4j.bolt.protocol.v40.transaction.TransactionStateMachineSPIProviderV4;
import org.neo4j.bolt.protocol.v44.BoltProtocolV44;
import org.neo4j.bolt.protocol.v50.fsm.StateMachineV50;
import org.neo4j.bolt.protocol.v50.message.decoder.BeginMessageDecoder;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.storable.Value;

public class BoltProtocolV50
extends BoltProtocolV44 {
    public static final ProtocolVersion VERSION = new ProtocolVersion(5, 0);

    public BoltProtocolV50(LogService logging, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, DefaultDatabaseResolver defaultDatabaseResolver, TransactionManager transactionManager, SystemNanoClock clock) {
        super(logging, boltGraphDatabaseManagementServiceSPI, defaultDatabaseResolver, transactionManager, clock);
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    public Set<Feature> features() {
        return Set.of(Feature.UTC_DATETIME);
    }

    @Override
    public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(DefaultStructWriter.getInstance());
    }

    @Override
    public void registerStructReaders(StructRegistry.Builder<Connection, Value> builder) {
        builder.register(DateReader.getInstance()).register(DurationReader.getInstance()).register(LocalDateTimeReader.getInstance()).register(LocalTimeReader.getInstance()).register(Point2dReader.getInstance()).register(Point3dReader.getInstance()).register(TimeReader.getInstance()).register(DateTimeReader.getInstance()).register(DateTimeZoneIdReader.getInstance());
    }

    @Override
    protected StructRegistry<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().builderOf().register(BeginMessageDecoder.getInstance()).build();
    }

    @Override
    public StateMachine createStateMachine(Connection connection) {
        connection.memoryTracker().allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + StateMachineSPIImpl.SHALLOW_SIZE + StateMachineV50.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, connection, this.clock);
        StateMachineSPIImpl boltSPI = new StateMachineSPIImpl(this.logging, transactionSpiProvider);
        return new StateMachineV50(boltSPI, connection, (Clock)this.clock, this.defaultDatabaseResolver, this.transactionManager);
    }
}

