/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.dbapi.impl;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.dbapi.impl.BoltQueryExecutorImpl;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.memory.HeapEstimator;

public class BoltKernelTransaction
extends BoltQueryExecutorImpl
implements BoltTransaction {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltKernelTransaction.class);
    private final KernelTransaction kernelTransaction;
    private final InternalTransaction topLevelInternalTransaction;
    private final Supplier<BookmarkMetadata> bookmarkSupplier;

    public BoltKernelTransaction(QueryExecutionEngine queryExecutionEngine, TransactionalContextFactory transactionalContextFactory, KernelTransaction kernelTransaction, InternalTransaction internalTransaction, Supplier<BookmarkMetadata> bookmarkSupplier) {
        super(queryExecutionEngine, transactionalContextFactory, internalTransaction);
        this.kernelTransaction = kernelTransaction;
        this.topLevelInternalTransaction = internalTransaction;
        this.bookmarkSupplier = bookmarkSupplier;
    }

    @Override
    public void commit() throws TransactionFailureException {
        this.kernelTransaction.commit();
    }

    @Override
    public void rollback() throws TransactionFailureException {
        if (this.kernelTransaction.isOpen()) {
            this.kernelTransaction.rollback();
        }
    }

    @Override
    public void close() throws TransactionFailureException {
        if (this.kernelTransaction.isOpen()) {
            this.kernelTransaction.close();
        }
    }

    @Override
    public void markForTermination(Status reason) {
        this.kernelTransaction.markForTermination(reason);
    }

    @Override
    public void markForTermination() {
        this.kernelTransaction.markForTermination((Status)Status.Transaction.Terminated);
    }

    @Override
    public Optional<Status> getReasonIfTerminated() {
        return this.topLevelInternalTransaction.terminationReason();
    }

    @Override
    public BookmarkMetadata getBookmarkMetadata() {
        return this.bookmarkSupplier.get();
    }
}

