/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.bolt.protocol.common.handler.TransportSelectionHandler;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class BoltChannelInitializer
extends ChannelInitializer<Channel> {
    private final Config config;
    private final Connector connector;
    private final ByteBufAllocator allocator;
    private final SslContext sslContext;
    private final InternalLogProvider logging;
    private final InternalLog log;

    public BoltChannelInitializer(Config config, Connector connector, ByteBufAllocator allocator, SslContext sslContext, InternalLogProvider logging) {
        this.config = config;
        this.allocator = allocator;
        this.connector = connector;
        this.sslContext = sslContext;
        this.logging = logging;
        this.log = logging.getLog(BoltChannelInitializer.class);
    }

    public BoltChannelInitializer(Config config, Connector connector, ByteBufAllocator allocator, InternalLogProvider logging) {
        this(config, connector, allocator, null, logging);
    }

    protected void initChannel(Channel ch) {
        this.log.debug("Incoming connection from %s", new Object[]{ch.remoteAddress()});
        ch.config().setAllocator(this.allocator);
        Connection connection = this.connector.createConnection(ch);
        connection.memoryTracker().allocateHeap(HeapEstimator.sizeOf((Object)ch) + TransportSelectionHandler.SHALLOW_SIZE);
        if (((Boolean)this.config.get(BoltConnectorInternalSettings.protocol_logging)).booleanValue()) {
            connection.memoryTracker().allocateHeap(ProtocolLoggingHandler.SHALLOW_SIZE);
            ch.pipeline().addLast("protocolLoggingHandler", (ChannelHandler)new ProtocolLoggingHandler(this.logging));
        }
        ch.pipeline().addLast(new ChannelHandler[]{new TransportSelectionHandler(this.config, this.sslContext, this.logging)});
        connection.notifyListeners(listener -> listener.onNetworkPipelineInitialized(ch.pipeline()));
    }
}

