/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.routing;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.common.routing.RoutingTableGetter;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class ProcedureRoutingTableGetter
implements RoutingTableGetter {
    private static final String GET_ROUTING_TABLE_STATEMENT = "CALL dbms.routing.getRoutingTable($routingContext, $databaseName)";
    private static final String ROUTING_CONTEXT_PARAM = "routingContext";
    private static final String DATABASE_NAME_PARAM = "databaseName";
    private static final String SYSTEM_DB_NAME = "system";

    @Override
    public CompletableFuture<MapValue> get(String programId, LoginContext loginContext, TransactionManager transactionManager, MapValue routingContext, List<Bookmark> bookmarks, String databaseName, String connectionId) {
        MapValue params = ProcedureRoutingTableGetter.getParams(routingContext, databaseName);
        CompletableFuture<MapValue> future = new CompletableFuture<MapValue>();
        try {
            ProgramResultReference programResultReference = transactionManager.runProgram(programId, loginContext, SYSTEM_DB_NAME, GET_ROUTING_TABLE_STATEMENT, params, Collections.emptyList(), true, Map.of(), null, connectionId);
            transactionManager.pullData(programId, programResultReference.statementMetadata().queryId(), -1L, new RoutingTableConsumer(future));
        }
        catch (Throwable throwable) {
            future.completeExceptionally(throwable);
        }
        return future;
    }

    private static MapValue getParams(MapValue routingContext, String databaseName) {
        MapValueBuilder paramsBuilder = new MapValueBuilder();
        paramsBuilder.add(ROUTING_CONTEXT_PARAM, (AnyValue)routingContext);
        paramsBuilder.add(DATABASE_NAME_PARAM, (AnyValue)Values.stringOrNoValue((String)databaseName));
        return paramsBuilder.build();
    }

    private static class RoutingTableConsumer
    implements ResultConsumer {
        private final CompletableFuture<MapValue> future;

        private RoutingTableConsumer(CompletableFuture<MapValue> future) {
            this.future = future;
        }

        @Override
        public void consume(BoltResult result) throws Throwable {
            RoutingTableRecordConsumer consumer = new RoutingTableRecordConsumer(this.future, result.fieldNames());
            result.handleRecords(consumer, 1L);
        }

        @Override
        public boolean hasMore() {
            return false;
        }
    }

    private static class RoutingTableRecordConsumer
    implements BoltResult.RecordConsumer {
        private final CompletableFuture<MapValue> future;
        private final MapValueBuilder mapValueBuilder;
        private final List<String> fields;
        private Iterator<String> fieldsIt;

        private RoutingTableRecordConsumer(CompletableFuture<MapValue> future, String[] fields) {
            this.future = future;
            this.mapValueBuilder = new MapValueBuilder();
            this.fields = List.of(fields);
        }

        @Override
        public void addMetadata(String key, AnyValue value) {
        }

        @Override
        public void beginRecord(int numberOfFields) throws IOException {
            this.fieldsIt = this.fields.iterator();
        }

        @Override
        public void consumeField(AnyValue value) throws IOException {
            this.mapValueBuilder.add(this.fieldsIt.next(), value);
        }

        @Override
        public void endRecord() throws IOException {
            this.future.complete(this.mapValueBuilder.build());
        }

        @Override
        public void onError() throws IOException {
            this.future.completeExceptionally(new RuntimeException("Error processing the record"));
        }
    }
}

