/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.BoltResultHandle;
import org.neo4j.bolt.protocol.common.transaction.TransactionStateMachineSPI;
import org.neo4j.bolt.protocol.common.transaction.result.AdaptingBoltQuerySubscriber;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorReleaseManager;
import org.neo4j.bolt.protocol.v40.bookmark.BookmarkWithDatabaseId;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractTransactionStateMachineSPI
implements TransactionStateMachineSPI {
    private final BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI;
    private final Clock clock;
    private final TransactionOwner owner;
    private final StatementProcessorReleaseManager resourceReleaseManager;
    private final String transactionId;

    public AbstractTransactionStateMachineSPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, TransactionOwner owner, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) {
        this.boltGraphDatabaseServiceSPI = boltGraphDatabaseServiceSPI;
        this.owner = owner;
        this.clock = clock;
        this.resourceReleaseManager = resourceReleaseManager;
        this.transactionId = transactionId;
    }

    @Override
    public Bookmark newestBookmark(BoltTransaction tx) {
        BookmarkMetadata bookmarkMetadata = tx.getBookmarkMetadata();
        return bookmarkMetadata.toBookmark(BookmarkWithDatabaseId::new);
    }

    @Override
    public BoltTransaction beginTransaction(KernelTransaction.Type transactionType, LoginContext loginContext, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext) {
        return this.boltGraphDatabaseServiceSPI.beginTransaction(transactionType, loginContext, this.owner.info(), bookmarks, txTimeout, accessMode, txMetadata, routingContext);
    }

    @Override
    public BoltResultHandle executeQuery(BoltQueryExecutor boltQueryExecutor, String statement, MapValue params) {
        return this.newBoltResultHandle(statement, params, boltQueryExecutor);
    }

    @Override
    public boolean supportsNestedStatementsInTransaction() {
        return false;
    }

    @Override
    public void transactionClosed() {
        this.boltGraphDatabaseServiceSPI.freeTransaction();
        this.resourceReleaseManager.releaseStatementProcessor(this.transactionId);
    }

    protected abstract BoltResultHandle newBoltResultHandle(String var1, MapValue var2, BoltQueryExecutor var3);

    public abstract class AbstractBoltResultHandle
    implements BoltResultHandle {
        private final String statement;
        private final MapValue params;
        private final BoltQueryExecutor boltQueryExecutor;
        private BoltQueryExecution boltQueryExecution;

        public AbstractBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            this.statement = statement;
            this.params = params;
            this.boltQueryExecutor = boltQueryExecutor;
        }

        @Override
        public BoltResult start() throws KernelException {
            try {
                AdaptingBoltQuerySubscriber subscriber = new AdaptingBoltQuerySubscriber();
                this.boltQueryExecution = this.boltQueryExecutor.executeQuery(this.statement, this.params, true, subscriber);
                QueryExecution result = this.boltQueryExecution.getQueryExecution();
                subscriber.assertSucceeded();
                return this.newBoltResult(result, subscriber, AbstractTransactionStateMachineSPI.this.clock);
            }
            catch (KernelException e) {
                throw new QueryExecutionKernelException((Throwable)e);
            }
            finally {
                this.close(false);
            }
        }

        protected abstract BoltResult newBoltResult(QueryExecution var1, AdaptingBoltQuerySubscriber var2, Clock var3);

        @Override
        public void close(boolean success) {
            if (this.boltQueryExecution != null) {
                this.boltQueryExecution.close();
            }
        }

        @Override
        public void terminate() {
            if (this.boltQueryExecution != null) {
                this.boltQueryExecution.terminate();
            }
        }
    }
}

