/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v41.message.decoder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v41.message.request.HelloMessage;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;

public final class HelloMessageDecoder
extends org.neo4j.bolt.protocol.v40.messaging.decoder.HelloMessageDecoder {
    private static final HelloMessageDecoder INSTANCE = new HelloMessageDecoder();
    public static final String ROUTING_KEY = "routing";

    private HelloMessageDecoder() {
    }

    public static HelloMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public org.neo4j.bolt.protocol.v40.messaging.request.HelloMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        Map<String, Object> meta = this.readMetaDataMap(valueReader, buffer.getTarget().readableBytes());
        this.validateMeta(meta);
        RoutingContext routingContext = HelloMessageDecoder.parseRoutingContext(meta);
        Map<String, Object> authToken = this.extractAuthToken(meta);
        return this.newHelloMessage(meta, routingContext, authToken);
    }

    private org.neo4j.bolt.protocol.v40.messaging.request.HelloMessage newHelloMessage(Map<String, Object> meta, RoutingContext routingContext, Map<String, Object> authToken) {
        return new HelloMessage(meta, routingContext, this.extractAuthToken(meta));
    }

    private static RoutingContext parseRoutingContext(Map<String, Object> meta) throws PackstreamReaderException {
        Object property = meta.getOrDefault(ROUTING_KEY, null);
        if (property == null) {
            return new RoutingContext(false, Collections.emptyMap());
        }
        if (!(property instanceof Map)) {
            throw new IllegalStructArgumentException(ROUTING_KEY, "Expected map but got " + property.getClass().getSimpleName());
        }
        Map routingObjectMap = meta.getOrDefault(ROUTING_KEY, null);
        HashMap<String, String> routingStringMap = new HashMap<String, String>();
        for (Map.Entry entry : routingObjectMap.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String) {
                String stringValue = (String)v;
                routingStringMap.put((String)entry.getKey(), stringValue);
                continue;
            }
            throw new IllegalStructArgumentException(ROUTING_KEY, "Must be a map with string keys and string values.");
        }
        return new RoutingContext(true, Map.copyOf(routingStringMap));
    }

    private Map<String, Object> extractAuthToken(Map<String, Object> meta) {
        return meta.entrySet().stream().filter(e -> !ROUTING_KEY.equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

