/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44.message.util;

import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class MessageMetadataParserV44 {
    private static final String IMPERSONATION_USER_KEY = "imp_user";

    private MessageMetadataParserV44() {
    }

    public static String parseImpersonatedUser(MapValue value) throws PackstreamReaderException {
        AnyValue anyValue = value.get(IMPERSONATION_USER_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            return stringValue.stringValue();
        }
        throw new IllegalStructArgumentException(IMPERSONATION_USER_KEY, "Expecting impersonated user value to be a String value, but got: " + anyValue);
    }
}

