/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44.transaction;

import java.time.Clock;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.BoltResultHandle;
import org.neo4j.bolt.protocol.common.transaction.AbstractTransactionStateMachineSPI;
import org.neo4j.bolt.protocol.common.transaction.result.AdaptingBoltQuerySubscriber;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorReleaseManager;
import org.neo4j.bolt.protocol.v40.transaction.TransactionStateMachineV4SPI;
import org.neo4j.bolt.protocol.v44.transaction.CypherAdapterStreamV44;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachineV44SPI
extends TransactionStateMachineV4SPI {
    public TransactionStateMachineV44SPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, TransactionOwner owner, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) {
        super(boltGraphDatabaseServiceSPI, owner, clock, resourceReleaseManager, transactionId);
    }

    @Override
    protected BoltResultHandle newBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
        return new BoltResultHandleV44(statement, params, boltQueryExecutor);
    }

    private class BoltResultHandleV44
    extends AbstractTransactionStateMachineSPI.AbstractBoltResultHandle {
        BoltResultHandleV44(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            super(TransactionStateMachineV44SPI.this, statement, params, boltQueryExecutor);
        }

        @Override
        protected BoltResult newBoltResult(QueryExecution result, AdaptingBoltQuerySubscriber subscriber, Clock clock) {
            return new CypherAdapterStreamV44(result, subscriber, clock, TransactionStateMachineV44SPI.this.databaseReference.alias().name());
        }
    }
}

