/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.packstream.error.reader.UnexpectedStructException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructRegistry;

public class PackstreamStructDecoder<CTX>
extends MessageToMessageDecoder<PackstreamBuf> {
    private final CTX ctx;
    private final StructRegistry<CTX, ?> registry;
    private final InternalLog log;

    public PackstreamStructDecoder(CTX ctx, StructRegistry<CTX, ?> registry, InternalLogProvider logging) {
        this.ctx = ctx;
        this.registry = registry;
        this.log = logging.getLog(PackstreamStructDecoder.class);
    }

    protected void decode(ChannelHandlerContext ctx, PackstreamBuf msg, List<Object> out) throws Exception {
        try {
            Object struct = msg.readStruct(this.ctx, this.registry);
            out.add(struct);
        }
        catch (UnexpectedStructException ex) {
            this.log.debug("Terminating connection due to invalid message", (Throwable)ex);
            ctx.close();
        }
    }
}

