/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.struct;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.packstream.struct.StructWriter;

public abstract class AbstractStructRegistry<CTX, S>
implements StructRegistry<CTX, S> {
    protected final Map<Short, StructReader<? super CTX, ? extends S>> tagToReaderMap;
    protected final Map<Class<?>, StructWriter<? super CTX, ? super S>> typeToWriterMap;

    public AbstractStructRegistry(Map<Short, StructReader<? super CTX, ? extends S>> tagToReaderMap, Map<Class<?>, StructWriter<? super CTX, ? super S>> typeToWriterMap) {
        this.tagToReaderMap = tagToReaderMap;
        this.typeToWriterMap = typeToWriterMap;
    }

    @Override
    public <C extends CTX> StructRegistry.Builder<C, S> builderOf() {
        return StructRegistry.builder().registerReaders(this.tagToReaderMap).registerWriters(this.typeToWriterMap);
    }

    @Override
    public Optional<? extends StructReader<? super CTX, ? extends S>> getReader(StructHeader header) {
        return Optional.ofNullable(this.tagToReaderMap.get(header.tag()));
    }

    @Override
    public <O extends S> Optional<? extends StructWriter<? super CTX, ? super O>> getWriter(O payload) {
        Class<?> payloadType = payload.getClass();
        StructWriter<? super CTX, ? super S> directMatch = this.typeToWriterMap.get(payloadType);
        if (directMatch != null) {
            return Optional.of(directMatch);
        }
        return this.typeToWriterMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(payloadType)).map(entry -> (StructWriter)entry.getValue()).findAny();
    }

    public static abstract class Builder<CTX, S>
    implements StructRegistry.Builder<CTX, S> {
        protected final Map<Short, StructReader<? super CTX, ? extends S>> tagToReaderMap;
        protected final Map<Class<?>, StructWriter<? super CTX, ? super S>> typeToWriterMap;

        protected Builder() {
            this(Collections.emptyMap(), Collections.emptyMap());
        }

        protected Builder(Map<Short, StructReader<? super CTX, ? extends S>> tagToReaderMap, Map<Class<?>, StructWriter<? super CTX, ? super S>> typeToWriterMap) {
            this.tagToReaderMap = new HashMap<Short, StructReader<CTX, S>>(tagToReaderMap);
            this.typeToWriterMap = new HashMap(typeToWriterMap);
        }

        @Override
        public StructRegistry.Builder<CTX, S> register(short tag, StructReader<? super CTX, ? extends S> reader) {
            this.tagToReaderMap.put(tag, reader);
            return this;
        }

        @Override
        public StructRegistry.Builder<CTX, S> unregisterReader(short tag) {
            this.tagToReaderMap.remove(tag);
            return this;
        }

        @Override
        public <T extends S> StructRegistry.Builder<CTX, S> register(Class<T> type, StructWriter<? super CTX, ? super T> writer) {
            this.typeToWriterMap.put(type, writer);
            return this;
        }
    }
}

