/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.dbapi.impl;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.dbapi.impl.BoltKernelTransaction;
import org.neo4j.bolt.dbapi.impl.PeriodicBoltKernelTransaction;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class BoltKernelGraphDatabaseServiceProvider
implements BoltGraphDatabaseServiceSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltKernelGraphDatabaseServiceProvider.class);
    private final TransactionIdTracker transactionIdTracker;
    private final GraphDatabaseAPI databaseAPI;
    private final QueryExecutionEngine queryExecutionEngine;
    private final TransactionalContextFactory transactionalContextFactory;
    private final NamedDatabaseId namedDatabaseId;
    private final Duration perBookmarkTimeout;
    private final MemoryTracker memoryTracker;

    public BoltKernelGraphDatabaseServiceProvider(GraphDatabaseAPI databaseAPI, TransactionIdTracker transactionIdTracker, Duration perBookmarkTimeout, MemoryTracker memoryTracker) {
        this.databaseAPI = databaseAPI;
        this.queryExecutionEngine = BoltKernelGraphDatabaseServiceProvider.resolveDependency(databaseAPI, QueryExecutionEngine.class);
        this.transactionIdTracker = transactionIdTracker;
        this.transactionalContextFactory = BoltKernelGraphDatabaseServiceProvider.newTransactionalContextFactory(databaseAPI);
        this.namedDatabaseId = databaseAPI.databaseId();
        this.perBookmarkTimeout = perBookmarkTimeout;
        this.memoryTracker = memoryTracker.getScopedMemoryTracker();
    }

    private static <T> T resolveDependency(GraphDatabaseAPI databaseContext, Class<T> clazz) {
        return (T)databaseContext.getDependencyResolver().resolveDependency(clazz);
    }

    private static TransactionalContextFactory newTransactionalContextFactory(GraphDatabaseAPI databaseContext) {
        GraphDatabaseQueryService queryService = BoltKernelGraphDatabaseServiceProvider.resolveDependency(databaseContext, GraphDatabaseQueryService.class);
        return Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)queryService);
    }

    private void awaitUpToDate(List<Bookmark> bookmarks) {
        for (Bookmark bookmark : bookmarks) {
            NamedDatabaseId databaseId = this.databaseIdFromBookmarkOrCurrent(bookmark);
            this.transactionIdTracker.awaitUpToDate(databaseId, bookmark.txId(), this.perBookmarkTimeout);
        }
    }

    private BookmarkMetadata bookmarkWithTxId() {
        return new BookmarkMetadata(this.transactionIdTracker.newestTransactionId(this.namedDatabaseId), this.namedDatabaseId);
    }

    @Override
    public BoltTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext, QueryExecutionConfiguration queryExecutionConfiguration) {
        this.awaitUpToDate(bookmarks);
        InternalTransaction topLevelInternalTransaction = this.beginInternalTransaction(type, loginContext, clientInfo, txTimeout, txMetadata);
        KernelTransaction kernelTransaction = topLevelInternalTransaction.kernelTransaction();
        if (KernelTransaction.Type.IMPLICIT == type) {
            this.memoryTracker.allocateHeap(PeriodicBoltKernelTransaction.SHALLOW_SIZE);
            return new PeriodicBoltKernelTransaction(this.queryExecutionEngine, this.transactionalContextFactory, topLevelInternalTransaction, this::bookmarkWithTxId, queryExecutionConfiguration);
        }
        this.memoryTracker.allocateHeap(BoltKernelTransaction.SHALLOW_SIZE);
        return new BoltKernelTransaction(this.queryExecutionEngine, this.transactionalContextFactory, kernelTransaction, topLevelInternalTransaction, this::bookmarkWithTxId, queryExecutionConfiguration);
    }

    @Override
    public DatabaseReference getDatabaseReference() {
        return new DatabaseReference.Internal(new NormalizedDatabaseName(this.namedDatabaseId.name()), this.namedDatabaseId, true);
    }

    private InternalTransaction beginInternalTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, Duration txTimeout, Map<String, Object> txMetadata) {
        InternalTransaction internalTransaction = txTimeout == null ? this.databaseAPI.beginTransaction(type, loginContext, clientInfo) : this.databaseAPI.beginTransaction(type, loginContext, clientInfo, txTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (txMetadata != null) {
            internalTransaction.setMetaData(txMetadata);
        }
        return internalTransaction;
    }

    private NamedDatabaseId databaseIdFromBookmarkOrCurrent(Bookmark bookmark) {
        NamedDatabaseId specifiedDatabaseId = bookmark.databaseId();
        if (specifiedDatabaseId == null) {
            return this.namedDatabaseId;
        }
        return specifiedDatabaseId;
    }

    @Override
    public void freeTransaction() {
        this.memoryTracker.reset();
    }
}

