/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.routing;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.routing.RoutingTableGetter;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class ProcedureRoutingTableGetter
implements RoutingTableGetter {
    private static final String GET_ROUTING_TABLE_STATEMENT = "CALL dbms.routing.getRoutingTable($routingContext, $databaseName)";
    private static final String ROUTING_CONTEXT_PARAM = "routingContext";
    private static final String DATABASE_NAME_PARAM = "databaseName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<MapValue> get(Transaction transaction, MapValue routingContext, String databaseName) {
        MapValue params = ProcedureRoutingTableGetter.getParams(routingContext, databaseName);
        CompletableFuture<MapValue> future = new CompletableFuture<MapValue>();
        try (Statement statement = transaction.run(GET_ROUTING_TABLE_STATEMENT, params);){
            statement.consume(new RoutingTableResponseHandler(future), -1L);
        }
        catch (TransactionException ex) {
            Throwable cause = ex.getCause();
            if (!(ex instanceof Status.HasStatus) && cause instanceof Status.HasStatus) {
                future.completeExceptionally(cause);
            }
            future.completeExceptionally(ex);
        }
        return future;
    }

    private static MapValue getParams(MapValue routingContext, String databaseName) {
        MapValueBuilder paramsBuilder = new MapValueBuilder();
        paramsBuilder.add(ROUTING_CONTEXT_PARAM, (AnyValue)routingContext);
        paramsBuilder.add(DATABASE_NAME_PARAM, (AnyValue)Values.stringOrNoValue((String)databaseName));
        return paramsBuilder.build();
    }

    private static class RoutingTableResponseHandler
    implements ResponseHandler,
    RecordHandler {
        private final CompletableFuture<MapValue> future;
        private final MapValueBuilder mapValueBuilder;
        private Iterator<String> fieldsIt;

        private RoutingTableResponseHandler(CompletableFuture<MapValue> future) {
            this.future = future;
            this.mapValueBuilder = new MapValueBuilder();
        }

        @Override
        public void onStatementPrepared(TransactionType transactionType, long statementId, long timeSpentPreparingResults, List<String> fieldNames) {
        }

        @Override
        public RecordHandler onBeginStreaming(List<String> fieldNames) {
            this.fieldsIt = fieldNames.iterator();
            return this;
        }

        @Override
        public void onField(AnyValue value) {
            this.mapValueBuilder.add(this.fieldsIt.next(), value);
        }

        @Override
        public void onCompleted() {
            this.future.complete(this.mapValueBuilder.build());
        }

        @Override
        public void onFailure() {
            this.future.completeExceptionally(new RuntimeException("Failed to generate routing table"));
        }

        @Override
        public void onStreamingMetadata(long timeSpentStreaming, QueryExecutionType executionType, DatabaseReference database, QueryStatistics statistics, Iterable<Notification> notifications) {
        }

        @Override
        public void onStreamingExecutionPlan(ExecutionPlanDescription plan) {
        }

        @Override
        public void onCompleteStreaming(boolean hasRemaining) {
        }

        @Override
        public void onBookmark(String encodedBookmark) {
        }

        @Override
        public void onSuccess() {
        }

        @Override
        public void onFailure(Error error) {
        }

        @Override
        public void onIgnored() {
        }

        @Override
        public void onMetadata(String key, AnyValue value) {
        }
    }
}

