/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40;

import java.time.Clock;
import java.util.function.Predicate;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.LegacyMetadataHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.message.encoder.FailureMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.IgnoredMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.SuccessMessageEncoder;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.reader.DateReader;
import org.neo4j.bolt.protocol.io.reader.DurationReader;
import org.neo4j.bolt.protocol.io.reader.LocalDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.LocalTimeReader;
import org.neo4j.bolt.protocol.io.reader.Point2dReader;
import org.neo4j.bolt.protocol.io.reader.Point3dReader;
import org.neo4j.bolt.protocol.io.reader.TimeReader;
import org.neo4j.bolt.protocol.io.reader.legacy.LegacyDateTimeReader;
import org.neo4j.bolt.protocol.io.reader.legacy.LegacyDateTimeZoneIdReader;
import org.neo4j.bolt.protocol.io.writer.LegacyStructWriter;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.protocol.v40.messaging.decoder.BeginMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.CommitMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.DiscardMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.GoodbyeMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.HelloMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.PullMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.ResetMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.RollbackMessageDecoder;
import org.neo4j.bolt.protocol.v40.messaging.decoder.RunMessageDecoder;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.signal.FrameSignal;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.storable.Value;

public class BoltProtocolV40
implements BoltProtocol {
    public static final ProtocolVersion VERSION = new ProtocolVersion(4, 0);
    protected final LogService logging;
    protected final Log log;
    protected final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;
    protected final SystemNanoClock clock;
    private final StructRegistry<Connection, RequestMessage> requestMessageStructRegistry;
    private final StructRegistry<Connection, ResponseMessage> responseMessageStructRegistry;

    public BoltProtocolV40(LogService logging, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, SystemNanoClock clock) {
        this.logging = logging;
        this.log = logging.getInternalLog(this.getClass());
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.clock = clock;
        this.requestMessageStructRegistry = this.createRequestMessageRegistry();
        this.responseMessageStructRegistry = this.createResponseMessageRegistry();
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    public Predicate<FrameSignal> frameSignalFilter() {
        return signal -> signal != FrameSignal.MESSAGE_END;
    }

    @Override
    public StateMachine createStateMachine(Connection connection) {
        connection.memoryTracker().allocateHeap(StateMachineSPIImpl.SHALLOW_SIZE + StateMachineV40.SHALLOW_SIZE);
        StateMachineSPIImpl boltSPI = new StateMachineSPIImpl(this.logging);
        return new StateMachineV40(boltSPI, connection, (Clock)this.clock);
    }

    protected StructRegistry<Connection, RequestMessage> createRequestMessageRegistry() {
        return StructRegistry.builder().register(HelloMessageDecoder.getInstance()).register(RunMessageDecoder.getInstance()).register(DiscardMessageDecoder.getInstance()).register(PullMessageDecoder.getInstance()).register(BeginMessageDecoder.getInstance()).register(CommitMessageDecoder.getInstance()).register(RollbackMessageDecoder.getInstance()).register(ResetMessageDecoder.getInstance()).register(GoodbyeMessageDecoder.getInstance()).build();
    }

    @Override
    public final StructRegistry<Connection, RequestMessage> requestMessageRegistry() {
        return this.requestMessageStructRegistry;
    }

    protected StructRegistry<Connection, ResponseMessage> createResponseMessageRegistry() {
        return StructRegistry.builder().register(FailureMessageEncoder.getInstance()).register(IgnoredMessageEncoder.getInstance()).register(SuccessMessageEncoder.getInstance()).build();
    }

    @Override
    public final StructRegistry<Connection, ResponseMessage> responseMessageRegistry() {
        return this.responseMessageStructRegistry;
    }

    @Override
    public void registerStructReaders(StructRegistry.Builder<Connection, Value> builder) {
        builder.register(DateReader.getInstance()).register(DurationReader.getInstance()).register(LocalDateTimeReader.getInstance()).register(LocalTimeReader.getInstance()).register(Point2dReader.getInstance()).register(Point3dReader.getInstance()).register(TimeReader.getInstance()).register(LegacyDateTimeReader.getInstance()).register(LegacyDateTimeZoneIdReader.getInstance());
    }

    @Override
    public void registerStructWriters(WriterPipeline pipeline) {
        BoltProtocol.super.registerStructWriters(pipeline);
        pipeline.addFirst(LegacyStructWriter.getInstance());
    }

    @Override
    public MetadataHandler metadataHandler() {
        return LegacyMetadataHandler.getInstance();
    }

    public String toString() {
        return this.version().toString();
    }
}

