/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.v40.fsm.AbstractStreamingState;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.memory.HeapEstimator;

public class AutoCommitState
extends AbstractStreamingState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AutoCommitState.class);

    @Override
    public String name() {
        return "AUTOCOMMIT";
    }

    @Override
    protected State processStreamPullResultMessage(Transaction tx, Statement statement, StateMachineContext context, long noToPull) throws Throwable {
        super.processStreamPullResultMessage(tx, statement, context, noToPull);
        if (!statement.hasRemaining()) {
            this.commit(context, tx);
            return this.readyState;
        }
        return this;
    }

    @Override
    protected State processStreamDiscardResultMessage(Transaction tx, Statement statement, StateMachineContext context, long noToDiscard) throws Throwable {
        super.processStreamDiscardResultMessage(tx, statement, context, noToDiscard);
        if (!statement.hasRemaining()) {
            this.commit(context, tx);
            return this.readyState;
        }
        return this;
    }
}

