/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.CommitMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.DiscardMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.PullMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RollbackMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;

public class FailedState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(FailedState.class);

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        if (this.shouldIgnore(message)) {
            context.connectionState().markIgnored();
            return this;
        }
        return null;
    }

    @Override
    public String name() {
        return "FAILED";
    }

    protected boolean shouldIgnore(RequestMessage message) {
        return message instanceof RunMessage || message instanceof PullMessage || message instanceof DiscardMessage || message == CommitMessage.INSTANCE || message == RollbackMessage.INSTANCE;
    }
}

