/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.decoder;

import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.ReadMetadataUtils;
import org.neo4j.bolt.protocol.v40.messaging.request.HelloMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;

public class HelloMessageDecoder
implements StructReader<Connection, HelloMessage> {
    private static final HelloMessageDecoder INSTANCE = new HelloMessageDecoder();

    protected HelloMessageDecoder() {
    }

    public static HelloMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 1;
    }

    @Override
    public HelloMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> reader = ctx.valueReader(buffer);
        Map<String, Object> meta = this.readMetaDataMap(reader, buffer.getTarget().readableBytes());
        this.validateMeta(meta);
        return new HelloMessage(meta);
    }

    protected void validateMeta(Map<String, Object> meta) throws PackstreamReaderException {
        Object userAgent = meta.get("user_agent");
        if (userAgent == null) {
            throw new IllegalStructArgumentException("user_agent", "Expected \"user_agent\" to be non-null");
        }
        if (!(userAgent instanceof String)) {
            throw new IllegalStructArgumentException("user_agent", "Expected value to be a string");
        }
    }

    protected Map<String, Object> readMetaDataMap(PackstreamValueReader<Connection> reader, int limit) throws PackstreamReaderException {
        return ReadMetadataUtils.readMetadataMap(reader, limit);
    }
}

