/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43.message.request;

import java.util.List;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.values.virtual.MapValue;

public class RouteMessage
implements RequestMessage {
    public static final byte SIGNATURE = 102;
    private static final String NAME = "ROUTE";
    private final MapValue requestContext;
    private final List<Bookmark> bookmarks;
    private final String databaseName;

    public RouteMessage(MapValue requestContext, List<Bookmark> bookmarks, String databaseName) {
        this.databaseName = databaseName;
        this.requestContext = requestContext;
        this.bookmarks = bookmarks;
    }

    public MapValue getRequestContext() {
        return this.requestContext;
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return true;
    }

    public String toString() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o instanceof RouteMessage) {
            RouteMessage that = (RouteMessage)o;
            return Objects.equals(this.requestContext, that.requestContext) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.bookmarks, that.bookmarks);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.requestContext, this.bookmarks, this.databaseName);
    }
}

