/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44;

import java.time.Clock;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.DefaultMetadataHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v43.BoltProtocolV43;
import org.neo4j.bolt.protocol.v44.fsm.StateMachineV44;
import org.neo4j.bolt.protocol.v44.message.decoder.BeginMessageDecoder;
import org.neo4j.bolt.protocol.v44.message.decoder.RouteMessageDecoder;
import org.neo4j.bolt.protocol.v44.message.decoder.RunMessageDecoder;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;

public class BoltProtocolV44
extends BoltProtocolV43 {
    public static final ProtocolVersion VERSION = new ProtocolVersion(4, 4);

    public BoltProtocolV44(LogService logging, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, SystemNanoClock clock) {
        super(logging, boltGraphDatabaseManagementServiceSPI, clock);
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected StructRegistry<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().builderOf().register(BeginMessageDecoder.getInstance()).register(RouteMessageDecoder.getInstance()).register(RunMessageDecoder.getInstance()).build();
    }

    @Override
    public StateMachine createStateMachine(Connection connection) {
        connection.memoryTracker().allocateHeap(StateMachineSPIImpl.SHALLOW_SIZE + StateMachineV44.SHALLOW_SIZE);
        StateMachineSPIImpl boltSPI = new StateMachineSPIImpl(this.logging);
        return new StateMachineV44(boltSPI, connection, (Clock)this.clock);
    }

    @Override
    public MetadataHandler metadataHandler() {
        return DefaultMetadataHandler.getInstance();
    }
}

