/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v50.message.util;

import java.util.Locale;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class MessageMetadataParserV50 {
    public static final String TX_TYPE_KEY = "tx_type";

    public static TransactionType parseTxType(MapValue meta) throws PackstreamReaderException {
        AnyValue anyValue = meta.get(TX_TYPE_KEY);
        if (anyValue == Values.NO_VALUE) {
            return null;
        }
        if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            try {
                return TransactionType.valueOf(stringValue.stringValue().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return TransactionType.EXPLICIT;
            }
        }
        return TransactionType.EXPLICIT;
    }
}

