/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.message.decoder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.protocol.v51.message.request.HelloMessage;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.virtual.MapValue;

public class HelloMessageDecoder
implements StructReader<Connection, HelloMessage> {
    private static final HelloMessageDecoder INSTANCE = new HelloMessageDecoder();
    public static final String ROUTING_KEY = "routing";

    protected HelloMessageDecoder() {
    }

    public static HelloMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 1;
    }

    @Override
    public HelloMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        Map<String, Object> meta = this.readMetadataMap(valueReader, buffer.getTarget().readableBytes());
        this.validateMeta(meta);
        RoutingContext routingContext = HelloMessageDecoder.parseRoutingContext(meta);
        return new HelloMessage(meta, routingContext);
    }

    protected void validateMeta(Map<String, Object> meta) throws PackstreamReaderException {
        Object userAgent = meta.get("user_agent");
        if (userAgent == null) {
            throw new IllegalStructArgumentException("user_agent", "Expected \"user_agent\" to be non-null");
        }
        if (!(userAgent instanceof String)) {
            throw new IllegalStructArgumentException("user_agent", "Expected value to be a string");
        }
    }

    private static RoutingContext parseRoutingContext(Map<String, Object> meta) throws PackstreamReaderException {
        Object property = meta.getOrDefault(ROUTING_KEY, null);
        if (property == null) {
            return new RoutingContext(false, Collections.emptyMap());
        }
        if (!(property instanceof Map)) {
            throw new IllegalStructArgumentException(ROUTING_KEY, "Expected map but got " + property.getClass().getSimpleName());
        }
        Map routingObjectMap = meta.getOrDefault(ROUTING_KEY, null);
        HashMap<String, String> routingStringMap = new HashMap<String, String>();
        for (Map.Entry entry : routingObjectMap.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String) {
                String stringValue = (String)v;
                routingStringMap.put((String)entry.getKey(), stringValue);
                continue;
            }
            throw new IllegalStructArgumentException(ROUTING_KEY, "Must be a map with string keys and string values.");
        }
        return new RoutingContext(true, Map.copyOf(routingStringMap));
    }

    protected Map<String, Object> readMetadataMap(PackstreamValueReader<Connection> reader, int limit) throws PackstreamReaderException {
        MapValue metaDataMapValue;
        try {
            metaDataMapValue = reader.readPrimitiveMap(limit);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("extra", ex);
        }
        HelloMessageValueWriter writer = new HelloMessageValueWriter();
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>(metaDataMapValue.size());
        metaDataMapValue.foreach((key, value) -> {
            value.writeTo((AnyValueWriter)writer);
            metaDataMap.put((String)key, writer.value());
        });
        return metaDataMap;
    }

    private static class HelloMessageValueWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private HelloMessageValueWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Hello Message should not contain nodes");
        }

        protected Node newNodeEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Hello Message should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Hello Message should not contain relationships");
        }

        protected Relationship newRelationshipEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Hello Message should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            throw new UnsupportedOperationException("Hello Message should not contain relationships");
        }

        Object valueAsObject(AnyValue value) {
            value.writeTo((AnyValueWriter)this);
            return this.value();
        }
    }
}

