/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.message.request;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;

public class HelloMessage
implements RequestMessage {
    public static final byte SIGNATURE = 1;
    private static final String USER_AGENT = "user_agent";
    private static final String FEATURES = "patch_bolt";
    private final Map<String, Object> meta;
    private final RoutingContext routingContext;

    public HelloMessage(Map<String, Object> meta, RoutingContext routingContext) {
        this.routingContext = routingContext;
        this.meta = Objects.requireNonNull(meta);
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    public String userAgent() {
        return Objects.requireNonNull((String)this.meta.get(USER_AGENT));
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public List<Feature> features() {
        Object param = this.meta.get(FEATURES);
        if (!(param instanceof List)) {
            return Collections.emptyList();
        }
        return ((List)param).stream().filter(it -> it instanceof String).map(id -> Feature.findFeatureById((String)id)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Object> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return "HELLO " + this.meta;
    }
}

