/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.dbapi.impl;

import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.values.virtual.MapValue;

public class BoltQueryExecutorImpl
implements BoltQueryExecutor {
    private final QueryExecutionEngine queryExecutionEngine;
    private final TransactionalContextFactory transactionalContextFactory;
    private final InternalTransaction internalTransaction;
    private final QueryExecutionConfiguration queryExecutionConfiguration;

    BoltQueryExecutorImpl(QueryExecutionEngine queryExecutionEngine, TransactionalContextFactory transactionalContextFactory, InternalTransaction internalTransaction, QueryExecutionConfiguration queryExecutionConfiguration) {
        this.queryExecutionEngine = queryExecutionEngine;
        this.transactionalContextFactory = transactionalContextFactory;
        this.internalTransaction = internalTransaction;
        this.queryExecutionConfiguration = queryExecutionConfiguration;
    }

    @Override
    public BoltQueryExecution executeQuery(String query, MapValue parameters, boolean prePopulate, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        TransactionalContext transactionalContext = this.transactionalContextFactory.newContext(this.internalTransaction, query, parameters, this.queryExecutionConfiguration);
        QueryExecution queryExecution = this.queryExecutionEngine.executeQuery(query, parameters, transactionalContext, prePopulate, subscriber);
        return new BoltQueryExecutionImpl(queryExecution, transactionalContext);
    }

    private static class BoltQueryExecutionImpl
    implements BoltQueryExecution {
        private final QueryExecution queryExecution;
        private final TransactionalContext transactionalContext;

        BoltQueryExecutionImpl(QueryExecution queryExecution, TransactionalContext transactionalContext) {
            this.queryExecution = queryExecution;
            this.transactionalContext = transactionalContext;
        }

        @Override
        public QueryExecution getQueryExecution() {
            return this.queryExecution;
        }

        @Override
        public void close() {
            this.transactionalContext.close();
        }

        @Override
        public void terminate() {
            this.transactionalContext.terminate();
        }
    }
}

