/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.bookmark.BookmarkParser;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.netty.AbstractNettyConnector;
import org.neo4j.bolt.protocol.common.connector.transport.ConnectorTransport;
import org.neo4j.bolt.protocol.common.handler.BoltChannelInitializer;
import org.neo4j.bolt.security.Authentication;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.util.Preconditions;

public class DomainSocketNettyConnector
extends AbstractNettyConnector {
    private final Path path;
    private final Config config;
    private final ByteBufAllocator allocator;
    private final ConnectorTransport transport;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final InternalLogProvider logging;

    DomainSocketNettyConnector(String id, Path path, Config config, MemoryPool memoryPool, ByteBufAllocator allocator, EventLoopGroup bossGroup, EventLoopGroup workerGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintProvider connectionHintProvider, BookmarkParser bookmarkParser, TransactionManager transactionManager, int streamingBufferSize, int streamingFlushThreshold, RoutingService routingService, InternalLogProvider userLogProvider, InternalLogProvider logging) {
        super(id, (SocketAddress)new DomainSocketAddress(path.toFile()), memoryPool, connectionFactory, connectionTracker, false, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintProvider, bookmarkParser, transactionManager, streamingBufferSize, streamingFlushThreshold, routingService, userLogProvider, logging);
        Preconditions.checkArgument((transport.getDomainSocketChannelType() != null ? 1 : 0) != 0, (String)("Unsupported transport: " + transport.getName() + " does not support domain sockets"));
        this.path = path;
        this.config = config;
        this.allocator = allocator;
        this.transport = transport;
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.logging = logging;
    }

    public DomainSocketNettyConnector(String id, Path path, Config config, MemoryPool memoryPool, ByteBufAllocator allocator, EventLoopGroup eventLoopGroup, ConnectorTransport transport, Connection.Factory connectionFactory, NetworkConnectionTracker connectionTracker, BoltProtocolRegistry protocolRegistry, Authentication authentication, AuthConfigProvider authConfigProvider, DefaultDatabaseResolver defaultDatabaseResolver, ConnectionHintProvider connectionHintProvider, BookmarkParser bookmarkParser, TransactionManager transactionManager, int streamingBufferSize, int streamingFlushThreshold, RoutingService routingService, InternalLogProvider userLogProvider, InternalLogProvider logging) {
        this(id, path, config, memoryPool, allocator, eventLoopGroup, eventLoopGroup, transport, connectionFactory, connectionTracker, protocolRegistry, authentication, authConfigProvider, defaultDatabaseResolver, connectionHintProvider, bookmarkParser, transactionManager, streamingBufferSize, streamingFlushThreshold, routingService, userLogProvider, logging);
    }

    @Override
    protected EventLoopGroup bossGroup() {
        return this.bossGroup;
    }

    @Override
    protected EventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    @Override
    protected Class<? extends ServerChannel> channelType() {
        return this.transport.getDomainSocketChannelType();
    }

    @Override
    protected ChannelInitializer<Channel> channelInitializer() {
        return new BoltChannelInitializer(this.config, this, this.allocator, this.logging);
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (Files.exists(this.path, new LinkOption[0])) {
            if (!((Boolean)this.config.get(BoltConnectorInternalSettings.unsupported_loopback_delete)).booleanValue()) {
                throw new PortBindException(this.bindAddress, (Throwable)new BindException("Loopback listen file: " + this.path + " already exists."));
            }
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException ex) {
                throw new PortBindException(this.bindAddress, (Throwable)ex);
            }
        }
    }

    @Override
    protected void logStartupMessage() {
        this.userLog.info("Bolt (loopback) enabled on file %s", new Object[]{this.path});
    }
}

