/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.state;

import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.state.AbstractState;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.streaming.DiscardMessage;
import org.neo4j.bolt.protocol.common.message.request.streaming.PullMessage;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.error.statement.StatementExecutionException;
import org.neo4j.bolt.tx.error.statement.StatementStreamingException;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends AbstractState {
    protected State readyState;

    @Override
    protected State processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        State nextState = null;
        try {
            if (message instanceof PullMessage) {
                PullMessage pullMessage = (PullMessage)message;
                nextState = this.processStreamPullResultMessage(pullMessage.statementId(), context, pullMessage.n());
            } else if (message instanceof DiscardMessage) {
                DiscardMessage discardMessage = (DiscardMessage)message;
                nextState = this.processStreamDiscardResultMessage(discardMessage.statementId(), context, discardMessage.n());
            }
        }
        catch (StatementExecutionException | StatementStreamingException ex) {
            Throwable cause = ex.getCause();
            if (!(ex instanceof Status.HasStatus) && cause != null) {
                throw cause;
            }
            throw ex;
        }
        if (nextState != this) {
            context.connection().write((Object)StateSignal.EXIT_STREAMING);
        }
        return nextState;
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }

    protected State processStreamPullResultMessage(long statementId, StateMachineContext context, long noToPull) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        Transaction tx = context.connection().transaction().orElseThrow(() -> new IllegalStateException("Transaction has already been closed"));
        if (statementId == -1L) {
            statementId = tx.latestStatementId();
        }
        Statement statement = tx.getStatement(statementId).orElseThrow(() -> new IllegalStateException("Statement has already been closed"));
        return this.processStreamPullResultMessage(tx, statement, context, noToPull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State processStreamPullResultMessage(Transaction tx, Statement statement, StateMachineContext context, long noToPull) throws Throwable {
        ResponseHandler responseHandler = context.connectionState().getResponseHandler();
        try {
            statement.consume(responseHandler, noToPull);
        }
        finally {
            if (!statement.hasRemaining()) {
                statement.close();
            }
        }
        return this;
    }

    protected State processStreamDiscardResultMessage(long statementId, StateMachineContext context, long noToDiscard) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        Transaction tx = context.connection().transaction().orElseThrow(() -> new IllegalStateException("Transaction has already been closed"));
        if (statementId == -1L) {
            statementId = tx.latestStatementId();
        }
        Statement statement = tx.getStatement(statementId).orElseThrow(() -> new IllegalStateException("Statement has already been closed"));
        return this.processStreamDiscardResultMessage(tx, statement, context, noToDiscard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State processStreamDiscardResultMessage(Transaction tx, Statement statement, StateMachineContext context, long noToDiscard) throws Throwable {
        ResponseHandler responseHandler = context.connectionState().getResponseHandler();
        try {
            statement.discard(responseHandler, noToDiscard);
        }
        finally {
            if (!statement.hasRemaining()) {
                statement.close();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(StateMachineContext ctx, Transaction tx) throws TransactionException {
        Bookmark bookmark;
        ResponseHandler responseHandler = ctx.connectionState().getResponseHandler();
        try {
            bookmark = tx.commit();
        }
        finally {
            ctx.connection().closeTransaction();
        }
        bookmark.attachTo(responseHandler);
    }

    protected void rollback(StateMachineContext ctx, Transaction tx) throws TransactionException {
        try {
            tx.rollback();
        }
        finally {
            ctx.connection().closeTransaction();
        }
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

