/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.io.PackstreamBuf;

public class ProtocolLoggingHandler
extends ChannelDuplexHandler {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ProtocolLoggingHandler.class);
    public static final String RAW_NAME = "rawProtocolLoggingHandler";
    public static final String DECODED_NAME = "decodedProtocolLoggingHandler";
    private final InternalLog log;

    public ProtocolLoggingHandler(InternalLogProvider logging) {
        this(logging.getLog(ProtocolLoggingHandler.class));
    }

    public ProtocolLoggingHandler(InternalLog log) {
        this.log = log;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.logBlob(ctx.channel().remoteAddress(), true, buf);
        } else if (msg instanceof PackstreamBuf) {
            PackstreamBuf buf = (PackstreamBuf)msg;
            this.logBlob(ctx.channel().remoteAddress(), true, buf.getTarget());
        } else {
            this.log.info("[%s] >>> %s", new Object[]{ctx.channel().remoteAddress(), msg});
        }
        super.channelRead(ctx, msg);
    }

    private void logBlob(SocketAddress remoteAddress, boolean incoming, ByteBuf buf) {
        String direction = "<<<";
        if (incoming) {
            direction = ">>>";
        }
        this.log.info("[%s] %s Blob (%d bytes):\n%s", new Object[]{remoteAddress, direction, buf.readableBytes(), ByteBufUtil.prettyHexDump((ByteBuf)buf)});
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.logBlob(ctx.channel().remoteAddress(), false, buf);
        } else if (msg instanceof PackstreamBuf) {
            PackstreamBuf buf = (PackstreamBuf)msg;
            this.logBlob(ctx.channel().remoteAddress(), false, buf.getTarget());
        } else {
            this.log.info("[%s] <<< %s", new Object[]{ctx.channel().remoteAddress(), msg});
        }
        super.write(ctx, msg, promise);
    }
}

