/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Error {
    private final Status status;
    private final String message;
    private final Throwable cause;
    private final UUID reference;
    private final boolean fatal;
    private final Long queryId;

    private Error(Status status, String message, Throwable cause, boolean fatal, Long queryId) {
        this.status = status;
        this.message = message;
        this.cause = cause;
        this.fatal = fatal;
        this.reference = UUID.randomUUID();
        this.queryId = queryId;
    }

    private Error(Status status, String message, boolean fatal) {
        this(status, message, null, fatal, null);
    }

    private Error(Status status, Throwable cause, boolean fatal, Long queryId) {
        this(status, status.code().description(), cause, fatal, queryId);
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Throwable cause() {
        return this.cause;
    }

    public UUID reference() {
        return this.reference;
    }

    public Long queryId() {
        return this.queryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error that = (Error)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Neo4jError{status=" + this.status + ", message='" + this.message + "', cause=" + this.cause + ", reference=" + this.reference + "}";
    }

    public static Status codeFromString(String codeStr) {
        String[] parts = codeStr.split("\\.");
        if (parts.length != 4) {
            return Status.General.UnknownError;
        }
        String category = parts[2];
        String error = parts[3];
        return switch (category) {
            case "Schema" -> Status.Schema.valueOf((String)error);
            case "General" -> Status.General.valueOf((String)error);
            case "Statement" -> Status.Statement.valueOf((String)error);
            case "Transaction" -> Status.Transaction.valueOf((String)error);
            case "Request" -> Status.Request.valueOf((String)error);
            case "Security" -> Status.Security.valueOf((String)error);
            default -> Status.General.UnknownError;
        };
    }

    private static Error fromThrowable(Throwable any, boolean isFatal) {
        for (Throwable cause = any; cause != null; cause = cause.getCause()) {
            Long queryId = null;
            if (cause instanceof HasQuery) {
                queryId = ((HasQuery)cause).query();
            }
            if (cause instanceof DatabaseShutdownException) {
                return new Error((Status)Status.General.DatabaseUnavailable, cause, isFatal, queryId);
            }
            if (cause instanceof Status.HasStatus) {
                return new Error(((Status.HasStatus)cause).status(), cause.getMessage(), any, isFatal, queryId);
            }
            if (cause instanceof OutOfMemoryError) {
                return new Error((Status)Status.General.OutOfMemoryError, cause, isFatal, queryId);
            }
            if (!(cause instanceof StackOverflowError)) continue;
            return new Error((Status)Status.General.StackOverFlowError, cause, isFatal, queryId);
        }
        return new Error((Status)Status.General.UnknownError, any != null ? any.getMessage() : null, any, isFatal, null);
    }

    public static Error from(Status status, String message) {
        return new Error(status, message, false);
    }

    public static Error from(Throwable any) {
        return Error.fromThrowable(any, false);
    }

    public static Error fatalFrom(Throwable any) {
        return Error.fromThrowable(any, true);
    }

    public static Error fatalFrom(Status status, String message) {
        return new Error(status, message, true);
    }

    public boolean isFatal() {
        return this.fatal;
    }
}

