/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.AuthenticationMetadataUtils;
import org.neo4j.bolt.protocol.common.message.decoder.util.NotificationsConfigMetadataReader;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.authentication.HelloMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.packstream.util.PackstreamConversions;

public class DefaultHelloMessageDecoder
implements MessageDecoder<HelloMessage> {
    protected static final String FIELD_FEATURES = "patch_bolt";
    protected static final String FIELD_USER_AGENT = "user_agent";
    protected static final String FIELD_ROUTING = "routing";
    protected static final String FILED_NOTIFICATIONS_MIN_SEVERITY = "notifications_minimum_severity";
    protected static final String FILED_NOTIFICATIONS_DISABLED_CATEGORIES = "notifications_disabled_categories";
    private static final DefaultHelloMessageDecoder INSTANCE = new DefaultHelloMessageDecoder();

    protected DefaultHelloMessageDecoder() {
    }

    public static DefaultHelloMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 1;
    }

    @Override
    public HelloMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        PackstreamConditions.requireLength(header, 1);
        PackstreamValueReader<Connection> reader = ctx.valueReader(buffer);
        Map<String, Object> meta = AuthenticationMetadataUtils.convertExtraMap(reader, buffer.getTarget().readableBytes());
        String userAgent = this.readUserAgent(meta);
        List<Feature> features = this.readFeatures(meta);
        RoutingContext routingContext = this.readRoutingContext(meta);
        Map<String, Object> authToken = this.readAuthToken(meta);
        NotificationsConfig notificationsConfig = this.readNotificationsConfig(meta);
        return new HelloMessage(userAgent, features, routingContext, authToken, notificationsConfig);
    }

    protected NotificationsConfig readNotificationsConfig(Map<String, Object> meta) throws PackstreamReaderException {
        return NotificationsConfigMetadataReader.readFromMap(meta);
    }

    protected String readUserAgent(Map<String, Object> meta) throws PackstreamReaderException {
        return PackstreamConversions.asString(FIELD_USER_AGENT, meta.get(FIELD_USER_AGENT));
    }

    protected List<Feature> readFeatures(Map<String, Object> meta) {
        Object object = meta.get(FIELD_FEATURES);
        if (object instanceof List) {
            List listValue = (List)object;
            return listValue.stream().filter(it -> it instanceof String).map(id -> Feature.findFeatureById((String)id)).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    protected RoutingContext readRoutingContext(Map<String, Object> meta) throws PackstreamReaderException {
        Object property = meta.getOrDefault(FIELD_ROUTING, null);
        if (property == null) {
            return new RoutingContext(false, Collections.emptyMap());
        }
        if (property instanceof Map) {
            Map routingObjectMap = (Map)property;
            HashMap<String, String> routingStringMap = new HashMap<String, String>();
            for (Map.Entry entry : routingObjectMap.entrySet()) {
                Object object = entry.getKey();
                if (object instanceof String) {
                    String key = (String)object;
                    object = entry.getValue();
                    if (object instanceof String) {
                        String value = (String)object;
                        routingStringMap.put(key, value);
                        continue;
                    }
                }
                throw new IllegalStructArgumentException(FIELD_ROUTING, "Must be a map with string keys and string values.");
            }
            return new RoutingContext(true, Map.copyOf(routingStringMap));
        }
        throw new IllegalStructArgumentException(FIELD_ROUTING, "Expected map but got " + property.getClass().getSimpleName());
    }

    protected Map<String, Object> readAuthToken(Map<String, Object> meta) {
        return null;
    }
}

