/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.transaction;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.bookmark.BookmarkParser;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.decoder.MessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.NotificationsConfigMetadataReader;
import org.neo4j.bolt.protocol.common.message.decoder.util.TransactionInitiatingMetadataParser;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.transaction.AbstractTransactionInitiatingMessage;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.BaseToObjectValueWriter;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.util.PackstreamConversions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractTransactionInitiatingMessageDecoder<M extends AbstractTransactionInitiatingMessage>
implements MessageDecoder<M> {
    private static final String FIELD_ACCESS_MODE = "mode";
    private static final String FIELD_BOOKMARKS = "bookmarks";
    public static final String FIELD_TIMEOUT = "tx_timeout";
    public static final String FIELD_TYPE = "tx_type";
    private static final String FIELD_METADATA = "tx_metadata";

    protected AccessMode readAccessMode(MapValue meta) throws PackstreamReaderException {
        String accessMode = PackstreamConversions.asNullableStringValue(FIELD_ACCESS_MODE, meta.get(FIELD_ACCESS_MODE));
        if (accessMode == null) {
            return AccessMode.WRITE;
        }
        return AccessMode.byFlag(accessMode).orElseThrow(() -> new IllegalStructArgumentException(FIELD_ACCESS_MODE, "Expecting access mode value to be 'r' or 'w'"));
    }

    protected List<Bookmark> readBookmarks(Connection ctx, MapValue meta) throws PackstreamReaderException {
        ListValue listValue = PackstreamConversions.asNullableListValue(FIELD_BOOKMARKS, meta.get(FIELD_BOOKMARKS));
        if (listValue == null) {
            return List.of();
        }
        BookmarkParser parser = ctx.connector().bookmarkParser();
        return parser.parseBookmarks(listValue);
    }

    protected NotificationsConfig readNotificationsConfig(MapValue metadata) throws IllegalStructArgumentException {
        return NotificationsConfigMetadataReader.readFromMapValue(metadata);
    }

    protected String readImpersonatedUser(MapValue meta) throws PackstreamReaderException {
        return TransactionInitiatingMetadataParser.readImpersonatedUser(meta);
    }

    protected Duration readTimeout(MapValue meta) throws PackstreamReaderException {
        OptionalLong txTimeout = PackstreamConversions.asNullableLongValue(FIELD_TIMEOUT, meta.get(FIELD_TIMEOUT));
        if (!txTimeout.isPresent()) {
            return null;
        }
        return Duration.ofMillis(txTimeout.getAsLong());
    }

    protected Map<String, Object> readMetadata(MapValue meta) throws PackstreamReaderException {
        MapValue mapValue = PackstreamConversions.asNullableMapValue(FIELD_METADATA, meta.get(FIELD_METADATA));
        if (mapValue == null) {
            return null;
        }
        TransactionMetadataWriter writer = new TransactionMetadataWriter();
        HashMap<String, Object> txMeta = new HashMap<String, Object>(mapValue.size());
        mapValue.foreach((key, value) -> txMeta.put((String)key, writer.valueAsObject((AnyValue)value)));
        return txMeta;
    }

    private static class TransactionMetadataWriter
    extends BaseToObjectValueWriter<RuntimeException> {
        private TransactionMetadataWriter() {
        }

        protected Node newNodeEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain nodes");
        }

        protected Node newNodeEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Transaction metadata should not contain nodes");
        }

        protected Relationship newRelationshipEntityById(long id) {
            throw new UnsupportedOperationException("Transaction metadata should not contain relationships");
        }

        protected Relationship newRelationshipEntityByElementId(String elementId) {
            throw new UnsupportedOperationException("Transaction metadata should not contain relationships");
        }

        protected Point newPoint(CoordinateReferenceSystem crs, double[] coordinate) {
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinate);
        }

        Object valueAsObject(AnyValue value) {
            value.writeTo((AnyValueWriter)this);
            return this.value();
        }
    }
}

