/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.decoder.transaction;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.AbstractTransactionInitiatingMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.util.TransactionInitiatingMetadataParser;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.transaction.RunMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.virtual.MapValue;

public class DefaultRunMessageDecoder
extends AbstractTransactionInitiatingMessageDecoder<RunMessage> {
    private static final DefaultRunMessageDecoder INSTANCE = new DefaultRunMessageDecoder();

    protected DefaultRunMessageDecoder() {
    }

    public static DefaultRunMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 16;
    }

    @Override
    public RunMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue metadata;
        MapValue params;
        String statement;
        PackstreamConditions.requireLength(header, 3);
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            statement = buffer.readString();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("statement", ex);
        }
        try {
            params = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("params", ex);
        }
        try {
            metadata = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
        try {
            List<Bookmark> bookmarks = this.readBookmarks(ctx, metadata);
            Duration txTimeout = this.readTimeout(metadata);
            AccessMode accessMode = this.readAccessMode(metadata);
            Map<String, Object> txMetadata = this.readMetadata(metadata);
            String databaseName = TransactionInitiatingMetadataParser.readDatabaseName(metadata);
            String impersonatedUser = this.readImpersonatedUser(metadata);
            NotificationsConfig notificationsConfig = this.readNotificationsConfig(metadata);
            return new RunMessage(statement, params, bookmarks, txTimeout, accessMode, txMetadata, databaseName, impersonatedUser, notificationsConfig);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
    }
}

