/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.notifications;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;

public final class SelectiveNotificationsConfig
implements NotificationsConfig {
    private final Set<NotificationConfiguration.Category> categoriesToIgnore;
    private final NotificationConfiguration.Severity minimumSeverity;

    public SelectiveNotificationsConfig(String minimumSeverity, List<String> categoriesToIgnore) throws IllegalStructArgumentException {
        this.categoriesToIgnore = SelectiveNotificationsConfig.mapCategories(categoriesToIgnore);
        this.minimumSeverity = SelectiveNotificationsConfig.mapSeverity(minimumSeverity);
    }

    private static NotificationConfiguration.Severity mapSeverity(String minimumSeverity) throws IllegalStructArgumentException {
        if (minimumSeverity == null) {
            return null;
        }
        try {
            return Enum.valueOf(NotificationConfiguration.Severity.class, minimumSeverity.toUpperCase());
        }
        catch (IllegalArgumentException err) {
            throw new IllegalStructArgumentException("Could not parse a NotificationConfig's minimum severity.", err);
        }
    }

    private static Set<NotificationConfiguration.Category> mapCategories(List<String> cats) throws IllegalStructArgumentException {
        if (cats == null) {
            return null;
        }
        HashSet<NotificationConfiguration.Category> set = new HashSet<NotificationConfiguration.Category>();
        try {
            for (String x : cats) {
                set.add(Enum.valueOf(NotificationConfiguration.Category.class, x.toUpperCase()));
            }
        }
        catch (IllegalArgumentException err) {
            throw new IllegalStructArgumentException("Could not parse a NotificationConfig category to ignore.", err);
        }
        return set;
    }

    @Override
    public NotificationConfiguration buildConfiguration(NotificationsConfig parentConfig) {
        NotificationConfiguration.Severity sev = this.minimumSeverity;
        Set<Object> cats = this.categoriesToIgnore;
        if (parentConfig instanceof SelectiveNotificationsConfig) {
            SelectiveNotificationsConfig connectionConfig = (SelectiveNotificationsConfig)parentConfig;
            if (sev == null) {
                sev = connectionConfig.minimumSeverity;
            }
            if (cats == null) {
                cats = connectionConfig.categoriesToIgnore;
            }
        }
        if (sev == null) {
            sev = NotificationConfiguration.Severity.INFORMATION;
        }
        if (cats == null) {
            cats = Collections.emptySet();
        }
        return new NotificationConfiguration(sev, cats);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SelectiveNotificationsConfig) {
            SelectiveNotificationsConfig that = (SelectiveNotificationsConfig)o;
            return Objects.equals(this.minimumSeverity, that.minimumSeverity) && Objects.equals(this.categoriesToIgnore, that.categoriesToIgnore);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.minimumSeverity, this.categoriesToIgnore);
    }

    public String toString() {
        return "{ minimumSeverity=" + this.minimumSeverity.toString() + ", categoriesToIgnore=" + this.categoriesToIgnore.toString() + " }";
    }
}

