/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.transaction;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.tx.TransactionType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractTransactionInitiatingMessage
implements RequestMessage {
    private final List<Bookmark> bookmarks;
    private final Duration txTimeout;
    private final AccessMode accessMode;
    private final Map<String, Object> txMetadata;
    private final String databaseName;
    private final String impersonatedUser;
    private final NotificationsConfig notificationsConfig;

    protected AbstractTransactionInitiatingMessage() {
        this(List.of(), null, AccessMode.WRITE, Map.of(), null, null, null);
    }

    protected AbstractTransactionInitiatingMessage(List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName, String impersonatedUser, NotificationsConfig notificationsConfig) {
        this.bookmarks = bookmarks;
        this.txTimeout = txTimeout;
        this.accessMode = accessMode;
        this.txMetadata = txMetadata;
        this.databaseName = databaseName;
        this.impersonatedUser = impersonatedUser;
        this.notificationsConfig = notificationsConfig;
    }

    public List<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Map<String, Object> transactionMetadata() {
        return this.txMetadata;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String impersonatedUser() {
        return this.impersonatedUser;
    }

    public abstract TransactionType type();

    public NotificationsConfig notificationsConfig() {
        return this.notificationsConfig;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionInitiatingMessage that = (AbstractTransactionInitiatingMessage)o;
        return Objects.equals(this.bookmarks, that.bookmarks) && Objects.equals(this.txTimeout, that.txTimeout) && this.accessMode == that.accessMode && Objects.equals(this.txMetadata, that.txMetadata) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.impersonatedUser, that.impersonatedUser) && Objects.equals(this.notificationsConfig, that.notificationsConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookmarks, this.txTimeout, this.accessMode, this.txMetadata, this.databaseName, this.impersonatedUser, this.notificationsConfig});
    }

    public String toString() {
        String notifications = this.notificationsConfig != null ? this.notificationsConfig.toString() : "null";
        return "bookmarks=" + this.bookmarks + ", txTimeout=" + this.txTimeout + ", accessMode=" + this.accessMode + ", txMetadata=" + this.txMetadata + ", databaseName='" + this.databaseName + "', impersonatedUser='" + this.impersonatedUser + "', notificationsConfig=" + notifications;
    }
}

