/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm.state;

import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.authentication.HelloMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;

public class ConnectedState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConnectedState.class);
    public static final String CONNECTION_ID_KEY = "connection_id";
    protected State readyState;

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            return this.processHelloMessage(helloMessage, context);
        }
        return null;
    }

    protected State processHelloMessage(HelloMessage message, StateMachineContext context) throws BoltConnectionFatality {
        List<Feature> features = message.features();
        String userAgent = message.userAgent();
        Map<String, Object> authToken = message.authToken();
        RoutingContext routingContext = message.routingContext();
        NotificationsConfig notificationsConfig = message.notificationsConfig();
        List<Feature> enabledFeatures = context.connection().negotiate(features, userAgent, routingContext, notificationsConfig);
        if (this.processAuthentication(context, authToken)) {
            context.connectionState().onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.utf8Value((String)context.connectionId()));
            MapValueBuilder connectionHints = new MapValueBuilder();
            context.connection().connector().connectionHintProvider().append(connectionHints);
            context.connectionState().onMetadata("hints", (AnyValue)connectionHints.build());
            if (!enabledFeatures.isEmpty()) {
                ListValueBuilder builder = ListValueBuilder.newListBuilder((int)enabledFeatures.size());
                enabledFeatures.forEach(feature -> builder.add((AnyValue)Values.stringValue((String)feature.getId())));
                context.connectionState().onMetadata("patch_bolt", (AnyValue)builder.build());
            }
            return this.readyState;
        }
        return null;
    }

    protected boolean processAuthentication(StateMachineContext context, Map<String, Object> authToken) throws BoltConnectionFatality {
        try {
            StateMachineSPI boltSpi = context.boltSpi();
            MutableConnectionState connectionState = context.connectionState();
            connectionState.onMetadata("server", (AnyValue)Values.utf8Value((String)boltSpi.version()));
            AuthenticationFlag flags = context.connection().logon(authToken);
            if (flags != null) {
                connectionState.onMetadata(flags.name().toLowerCase(), (AnyValue)Values.TRUE);
            }
            return true;
        }
        catch (Throwable t) {
            context.handleFailure(t, true);
            return false;
        }
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }
}

