/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol;

import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultHelloMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogoffMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogonMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultGoodbyeMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultResetMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.connection.DefaultRouteMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.streaming.DefaultDiscardMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.streaming.DefaultPullMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultBeginMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultCommitMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultRollbackMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.transaction.DefaultRunMessageDecoder;
import org.neo4j.bolt.protocol.common.message.encoder.FailureMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.IgnoredMessageEncoder;
import org.neo4j.bolt.protocol.common.message.encoder.SuccessMessageEncoder;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.ResponseMessage;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractBoltProtocol
implements BoltProtocol {
    protected final SystemNanoClock clock;
    protected final LogService logging;
    private final StructRegistry<Connection, RequestMessage> requestMessageStructRegistry;
    private final StructRegistry<Connection, ResponseMessage> responseMessageStructRegistry;

    protected AbstractBoltProtocol(SystemNanoClock clock, LogService logging) {
        this.clock = clock;
        this.logging = logging;
        this.requestMessageStructRegistry = this.createRequestMessageRegistry().build();
        this.responseMessageStructRegistry = this.createResponseMessageRegistry().build();
    }

    @Override
    public final StructRegistry<Connection, RequestMessage> requestMessageRegistry() {
        return this.requestMessageStructRegistry;
    }

    @Override
    public final StructRegistry<Connection, ResponseMessage> responseMessageRegistry() {
        return this.responseMessageStructRegistry;
    }

    @Override
    public final StateMachine createStateMachine(Connection connection) {
        StateMachineSPI stateMachineSPI = this.createStateMachineSPI(connection);
        return this.createStateMachine(connection, stateMachineSPI);
    }

    protected StateMachineSPI createStateMachineSPI(Connection connection) {
        connection.memoryTracker().allocateHeap(StateMachineSPIImpl.SHALLOW_SIZE);
        return new StateMachineSPIImpl(this.logging);
    }

    protected abstract StateMachine createStateMachine(Connection var1, StateMachineSPI var2);

    protected StructRegistry.Builder<Connection, RequestMessage> createRequestMessageRegistry() {
        return StructRegistry.builder().register(DefaultHelloMessageDecoder.getInstance()).register(DefaultLogonMessageDecoder.getInstance()).register(DefaultLogoffMessageDecoder.getInstance()).register(DefaultGoodbyeMessageDecoder.getInstance()).register(DefaultResetMessageDecoder.getInstance()).register(DefaultRouteMessageDecoder.getInstance()).register(DefaultDiscardMessageDecoder.getInstance()).register(DefaultPullMessageDecoder.getInstance()).register(DefaultBeginMessageDecoder.getInstance()).register(DefaultCommitMessageDecoder.getInstance()).register(DefaultRollbackMessageDecoder.getInstance()).register(DefaultRunMessageDecoder.getInstance());
    }

    protected StructRegistry.Builder<Connection, ResponseMessage> createResponseMessageRegistry() {
        return StructRegistry.builder().register(FailureMessageEncoder.getInstance()).register(IgnoredMessageEncoder.getInstance()).register(SuccessMessageEncoder.getInstance());
    }

    public String toString() {
        return this.version().toString();
    }
}

