/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connection;

import java.time.Duration;
import java.util.function.Function;
import org.neo4j.bolt.protocol.common.connection.ConnectionHintProvider;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class DefaultConnectionHintProvider {
    private static final String HINT_CONNECTION_RECV_TIMEOUT_SECONDS = "connection.recv_timeout_seconds";
    public static final Function<Config, ConnectionHintProvider> CONNECTION_HINT_PROVIDER_FUNCTION = config -> hints -> {
        if (config.get(BoltConnector.connection_keep_alive_type) == BoltConnector.KeepAliveRequestType.ALL) {
            Duration keepAliveInterval = (Duration)config.get(BoltConnector.connection_keep_alive);
            Integer keepAliveProbes = (Integer)config.get(BoltConnector.connection_keep_alive_probes);
            hints.add(HINT_CONNECTION_RECV_TIMEOUT_SECONDS, (AnyValue)Values.longValue((long)(keepAliveInterval.toSeconds() * (long)keepAliveProbes.intValue())));
        }
    };

    private DefaultConnectionHintProvider() {
    }
}

