/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;

public class StateMachineContextImpl
implements StateMachineContext {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineContextImpl.class);
    private final Connection connection;
    private final StateMachine machine;
    private final StateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;

    public StateMachineContextImpl(Connection connection, StateMachine machine, StateMachineSPI spi, MutableConnectionState connectionState, Clock clock) {
        this.connection = connection;
        this.machine = machine;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
    }

    @Override
    public String connectionId() {
        return this.connection.id();
    }

    @Override
    public Connection connection() {
        return this.connection;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public StateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }
}

