/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm;

import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;

public class StateMachineSPIImpl
implements StateMachineSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineSPIImpl.class);
    public static final String BOLT_SERVER_VERSION_PREFIX = "Neo4j/";
    private final String version = "Neo4j/" + Version.getNeo4jVersion();
    private final Log userLog;
    private final Log debugLog;

    public StateMachineSPIImpl(LogService logging) {
        this.userLog = logging.getUserLog(StateMachineSPIImpl.class);
        this.debugLog = logging.getInternalLog(StateMachineSPIImpl.class);
    }

    @Override
    public void reportError(Error error) {
        if (error.status().code().classification() == Status.Classification.DatabaseError) {
            String message = error.queryId() != null ? String.format("Client triggered an unexpected error [%s]: %s, reference %s, queryId: %s.", error.status().code().serialize(), error.message(), error.reference(), error.queryId()) : String.format("Client triggered an unexpected error [%s]: %s, reference %s.", error.status().code().serialize(), error.message(), error.reference());
            this.userLog.error(message);
            if (error.cause() != null) {
                this.debugLog.error(message, error.cause());
            }
        }
    }

    @Override
    public String version() {
        return this.version;
    }
}

