/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43.fsm;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.AbstractStateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.fsm.state.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.state.AutoCommitState;
import org.neo4j.bolt.protocol.v40.fsm.state.ConnectedState;
import org.neo4j.bolt.protocol.v40.fsm.state.InTransactionState;
import org.neo4j.bolt.protocol.v43.fsm.state.FailedState;
import org.neo4j.bolt.protocol.v43.fsm.state.ReadyState;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class StateMachineV43
extends AbstractStateMachine {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineV43.class);

    public StateMachineV43(StateMachineSPI spi, Connection connection, Clock clock) {
        super(spi, connection, clock);
    }

    @Override
    protected AbstractStateMachine.States buildStates(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(ConnectedState.SHALLOW_SIZE + ReadyState.SHALLOW_SIZE + AutoCommitState.SHALLOW_SIZE + InTransactionState.SHALLOW_SIZE + FailedState.SHALLOW_SIZE + InterruptedState.SHALLOW_SIZE);
        ConnectedState connected = new ConnectedState();
        AutoCommitState autoCommitState = new AutoCommitState();
        InTransactionState inTransaction = new InTransactionState();
        FailedState failed = new FailedState();
        ReadyState ready = new ReadyState();
        InterruptedState interrupted = new InterruptedState();
        connected.setReadyState(ready);
        ready.setTransactionReadyState(inTransaction);
        ready.setStreamingState(autoCommitState);
        ready.setFailedState(failed);
        autoCommitState.setReadyState(ready);
        autoCommitState.setFailedState(failed);
        inTransaction.setReadyState(ready);
        inTransaction.setFailedState(failed);
        interrupted.setReadyState(ready);
        return new AbstractStateMachine.States(connected, failed, interrupted);
    }
}

