/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import java.util.Optional;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionCloseException;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.error.statement.StatementException;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

public interface Transaction {
    public String id();

    public TransactionType type();

    public boolean isOpen();

    public boolean isValid();

    public long latestStatementId();

    public boolean hasOpenStatement();

    public Statement run(String var1, MapValue var2) throws StatementException;

    public Optional<Statement> getStatement(long var1);

    public String commit() throws TransactionException;

    public void rollback() throws TransactionException;

    public void interrupt();

    public Optional<Status> validate();

    public void close() throws TransactionCloseException;

    public void registerListener(Listener var1);

    public void removeListener(Listener var1);

    public static interface Listener {
        default public void onCommit(Transaction transaction, String bookmark) {
        }

        default public void onRollback(Transaction transaction) {
        }

        default public void onClose(Transaction transaction) {
        }
    }
}

