/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import org.neo4j.bolt.txtracking.ReconciledTransactionTracker;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.TransactionIdStore;

public class SimpleReconciledTransactionTracker
implements ReconciledTransactionTracker {
    private final DatabaseManagementService dbService;
    private final InternalLog log;

    public SimpleReconciledTransactionTracker(DatabaseManagementService dbService, LogService logService) {
        this.dbService = dbService;
        this.log = logService.getInternalLog(this.getClass());
    }

    @Override
    public void disable() {
        throw new UnsupportedOperationException("Initialization is not supported");
    }

    @Override
    public void enable(long reconciledTransactionId) {
        throw new UnsupportedOperationException("Initialization is not supported");
    }

    @Override
    public long getLastReconciledTransactionId() {
        try {
            GraphDatabaseAPI systemDb = (GraphDatabaseAPI)this.dbService.database("system");
            if (systemDb.isAvailable()) {
                TransactionIdStore txIdStore = (TransactionIdStore)systemDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
                return txIdStore.getLastClosedTransactionId();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to get last reconciled transaction ID", (Throwable)e);
        }
        return -1L;
    }

    @Override
    public void offerReconciledTransactionId(long reconciledTransactionId) {
        throw new UnsupportedOperationException("Updates are not supported");
    }
}

